<?php

// NEW: جديد
// WAITING: جاري التوزيع للشركات
// PENDING: جاهز لتوزيع الأفراد
// CLOSED: مكتمل

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");

class AssignCargoCore {

    public function __construct(){
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------ //
    // --------------- get certain assign cargo by id ------------- //
    // ------------------------------------------------------------ //
    public function getAssignCargo($id,$user_id){

        $assignCargoInfo = DBConnection::getObjectBean("assign_cargo",$id,$user_id);
        return $assignCargoInfo;
    }

    // ------------------------------------------------------------------------------ //
    // -------------- get certain assign cargo by id without activities ------------- //
    // ------------------------------------------------------------------------------ //
    public function getAssignCargoBasic($id,$user_id){

        $assignCargoInfo = DBConnection::getBasicObjectBean("assign_cargo",$id,$user_id);
        return $assignCargoInfo;
    }


    // ------------------------------------------------------------------------------ //
    // -------------------search for assign_cargo using any search filter ----------- //
    // ------------------------------------------------------------------------------ //
    public function searchAssignCargo($searchFilter, $limit, $offset, $user_id , $order_by=null){

        $searchAssignCargoResult = DBConnection::searchDB("assign_cargo",$searchFilter, $limit, $offset,$user_id , $order_by);
        return $searchAssignCargoResult;

    }


    // ------------------------------------------------------------------------------ //
    // --------------- Create new assign cargo -------------------------------------- //
    // ------------------------------------------------------------------------------ //
    public function createAssignCargo($assignResult , $user_id){

        $saveDistributionResult = DBConnection::insertDB("assign_cargo",$assignResult,$user_id);
        $assign_cargo_id =  $saveDistributionResult[0]['@id'];

        return $assign_cargo_id;

    }

    // ------------------------------------------------------------------- //
    // --------------- change status of assign_cargo --------------------- //
    // ------------------------------------------------------------------- //
    public function changeStatus($id, $new_status , $user_id){

        $updateBean = new stdClass();
        $updateBean->id = $id;
        $updateBean->status = $new_status;
        
        DBConnection::updateDB("assign_cargo",$updateBean,$user_id);
    }


    // ---------------------------------------------------------------------------------------- //
    // -------------generate Assign_Cargo bean For Indivisual assign -------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function generateAssignCargoForIndivisual($tender_id, $queue_id ,$serveTenderResult){
       
        // init
        $queueCore = new QueueCore();
        $tenderCore = new TenderCore();

        // calculate total trucks requested and prepare orders
        $total_count = 0;
        $ordersArr = [];
 
        foreach ($serveTenderResult['orders'] as $order) {
            
            $readable_questionnaire = $tenderCore->getReadableQuestionnaire($tender_id , $order['questionnaire']);
            $total_count += $order['trucks'];
            $orderJson = [
                "id" => $order['id'],
                "date" => $order['order_date'],
                "count" => $order['trucks'],
                "questionnaire" => $readable_questionnaire,
            ];
            array_push($ordersArr,$orderJson);
        }

        $tenderBean = $tenderCore->getTenderBasic($tender_id , 0);
        foreach ($tenderBean->manifest->queues as $q) {
            if($q->id == $queue_id){
                $queue_name = $q->name;
            }
        }                  
                 
        $details = [
            "info" => [
                "total_count" => $total_count,
                "tender_name" => $tenderBean->manifest->name,
                "queue_name" => $queue_name,
                "tender_id" => $tender_id,
                "queue_id" => $queue_id,
                "date" => DBConnection::getSystemDate()
            ],
            "orders" => $ordersArr          
        ];
 
        $queue_assign = [];
        foreach ($serveTenderResult['servedTrucks'] as $assign) {
            $temp = new stdClass();
            $temp->tn = $assign['tn']."+".$assign['trn'];
            $temp->cargo = $assign['cargo_name'];
            $temp->waybillOrder = $assign['selectedCargo']['waybillOrder'];
            $contact_name = str_replace("\\t","",$assign['contact_name']);
            $contact_name = trim(preg_replace('/\t+/', '',  $contact_name));
            $temp->contact_name = stripcslashes($contact_name);
            $temp->contact_phone = $assign['contact_phone'];

            $queue_assign['approved'][] = $temp;
        } 

        $queue_assign['rejected'] = [];
        foreach ($serveTenderResult['rejectedTrucks'] as $rejected) {
            $temp = new stdClass();
            $temp->tn = $rejected['tn']."+".$rejected['trn'];
            $temp->cargo = $rejected['cargo_name'];
            $temp->reason = $rejected['rejectionReason'];
            $contact_name = str_replace("\\t","",$assign['contact_name']);
            $contact_name = trim(preg_replace('/\t+/', '',  $contact_name));
            $temp->contact_name = stripcslashes($contact_name);
            $temp->contact_phone = $assign['contact_phone'];

            $queue_assign['rejected'][] = $temp;
            // only save the first 100 reject
            if(sizeof($queue_assign['rejected']) > 100){
                break;
            }

        }

        $resultStruct = new stdClass();
        $resultStruct->details = json_encode($details,JSON_UNESCAPED_UNICODE);
        $resultStruct->tender_id = $tender_id;
        $resultStruct->company_assign = [];
        $resultStruct->queue_assign = json_encode($queue_assign,JSON_UNESCAPED_UNICODE);
        $resultStruct->list_of_waybills = [];
        $resultStruct->status = 'NEW';

        return $resultStruct;

    }

    // ---------------------------------------------------------------------------------------- //
    // -------------generate Assign_Cargo bean For company assign -------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function generateAssignCargoForCompany($tender_id, $queue_id ,$serveTenderResult){
       
        // init
        $queueCore = new QueueCore();
        $tenderCore = new TenderCore();

        // calculate total trucks requested and prepare orders
        $total_count = 0;
        $ordersArr = [];
        $tenderBean = $tenderCore->getTenderBasic($tender_id , 0);
        foreach ($tenderBean->manifest->queues as $q) {
            if($q->id == $queue_id){
                $queue_name = $q->name;
            }
        }

        $orders = [];
        foreach ($serveTenderResult['orders'] as $o) {

            // get a human readable questionnaire , (make each question human readable)
            $readable_questionnaire = $tenderCore->getReadableQuestionnaire($tender_id , $o['questionnaire']);
            $OrderObj = new stdClass();
            $OrderObj->id = $o['id'];
            $OrderObj->count = $o['trucks'];
            $OrderObj->questionnaire = $readable_questionnaire;
            $orders[] = $OrderObj;
        }

        $details = [
            "info" => [
                "total_count" => $serveTenderResult['totalRequiredTrucks'],
                "tender_name" => $tenderBean->manifest->name,
                "queue_name" => $queue_name,
                "tender_id" => $tender_id,
                "queue_id" => $queue_id,
                "date" => DBConnection::getSystemDate(),
                "auto_assign_for_indivisual" => false // TODO
            ],
            "orders" => $orders
        ];

        $company_assign = [];
        $company_assign['approved'] = [];
        $company_assign['rejected'] = [];

        foreach ($serveTenderResult['servedCompanies'] as $assign) {
            $temp = new stdClass();
            $temp->company_name = $assign['name'];
            $temp->quota = $assign['quota'];
            $temp->residual = $assign['residual'];
            $temp->used_quota = $assign['used_quota'];
            $company_assign['approved'][] = $temp;
        } 
        foreach ($serveTenderResult['rejectedCompanies'] as $rejected) {
            $temp = new stdClass();
            $temp->company_name = $rejected['name'];
            $temp->reason = $rejected['rejectionReason'];
            $company_assign['rejected'][] = $temp;
        }


        $resultStruct = new stdClass();
        $resultStruct->details = json_encode($details,JSON_UNESCAPED_UNICODE);
        $resultStruct->tender_id = $tender_id;
        $resultStruct->company_assign = json_encode($company_assign,JSON_UNESCAPED_UNICODE);
        $resultStruct->queue_assign = [];
        $resultStruct->list_of_waybills = [];
        $resultStruct->status = 'NEW';

        return $resultStruct;

    }


    // ------------------------------------------------------------------------------------------------ //
    // ----------------- generate node for indivusial assign ------------------------------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function generateAssignQueueNode($serveTenderResult){

        $queue_assign = [];
        $queue_assign['approved']=[];
        $queue_assign['rejected']=[];

        // write the indivisual distribute result in assign cargo
        foreach ($serveTenderResult['servedTrucks'] as $served) {

            $servedObj = new stdClass();
            $servedObj->tn = $served['tn'] . "+" . $served['trn'];
            $servedObj->contact_name = cleanName($served['contact_name']);
            $servedObj->contact_phone = $served['contact_phone'];
            $queue_assign['approved'][] = $servedObj;      
        }

        // write the indivisual distribute result in assign cargo
        foreach ($serveTenderResult['rejectedTrucks'] as $rejected) {

            $rejectedObj = new stdClass();
            $rejectedObj->tn = $rejected['tn'] . " + " . $rejected['trn'];
            $rejectedObj->contact_name = cleanName($rejected['contact_name']);
            $rejectedObj->contact_phone = $rejected['contact_phone'];
            $rejectedObj->reason = $rejected['rejectionReason'];
            $queue_assign['rejected'][] = $rejectedObj;
        }

        return $queue_assign;
    }


    // ------------------------------------------------------------------------------ //
    // --------------------- Update tender order info in DB-------------------------- //
    // ------------------------------------------------------------------------------ //
    function updateAssignCargo($assignCargoBean,$assignCargoId, $updated_by){

        // fill update struct and set the target user id
        $assignCargoBean->id = $assignCargoId;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("assign_cargo",$assignCargoId,$updated_by);

        //update tender info only if the tender bean is different than DB bean
        if(compareObject($assignCargoBean,$DB_Bean) == false) {

            // map all the new values into the DB_bean
            $assignCargoBean = mapBeanToDBBean($assignCargoBean,$DB_Bean);

            // fill update struct and set the target user id
            DBConnection::updateDB("assign_cargo",$assignCargoBean,$updated_by);
        }
    }

}