<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/account_core.php");
require_once(dirname(__FILE__) . "/../trx/trx_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/payment_agent/payment_agent_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/../company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../../core/company_employee/company_employee_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/FPS.php");



class Account_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_accountCore;
    private $_tenderCore;
    private $_userCore;
    private $_paymentAgentCore;
    private $_truckingCompanyCore;
    private $_paymentCore;
    private $_companyEmployeeCore;
    private $_fps;


    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        // init the object
        $this->_accountCore = new AccountCore();
        $this->_trxCore = new TrxCore();
        $this->_tenderCore = new TenderCore();
        $this->_userCore = new UserCore();
        $this->_paymentAgentCore = new PaymentAgentCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_paymentCore = new PaymentCore();
        $this->_companyEmployeeCore = new CompanyEmployeeCore();
        $this->_fps = new FPS();

        DBConnection::getInstance();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ---------------------------------------------------------------------------- //
    // ------------------  prepare any json filter for search --------------------- //
    // ---------------------------------------------------------------------------- //
    private function prepareFilter()
    {
        $accountFilter = [];

        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);

            foreach ($filter as $key => $value) {
                if ($key == 'name') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else if ($key == "idWith") {
                    $tempArr = ['key' => "id", 'val' => $value, 'op' => 'startsWith'];
                } else if ($key == "payment_channel") {
                    $tempArr = ['key' => 'payment_channel', 'val' => "'$value'", 'op' => 'json unquote', 'node' => '$[0]'];                    
                } else if ($key == "user_id" || $key == "company_id") {
                    if ($value == 'is null' || $value == 'is not null') {
                        $tempArr = ['key' => 'name', 'op' => 'is not null'];
                        array_push($accountFilter, $tempArr);
                        $tempArr = ['key' => $key, 'op' => $value];
                    } else {
                        $tempArr = ['key' => $key, 'val' => $value];
                    }
                }
                else if ($key == 'date_from') {
                    $tempArr = ['key' => 'create_date', 'val' => "$value", 'op' => 'date greater than'];
                } else if ($key == 'date_to') {
                    $tempArr = ['key' => 'create_date', 'val' => "$value", 'op' => 'date less than'];
                }
                else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($accountFilter, $tempArr);
            }
        }

        // if session id for corporate , inject the account_ids filter
        $account_ids = $this->_accountCore->getAccountAuthority($_SESSION);
        if ($account_ids) {
            $tempArr = ['key' => 'sub_id', 'val' => $account_ids, 'op' => 'in'];
            array_push($accountFilter, $tempArr);
        }

        return $accountFilter;
    }

    // -------------------------------------------------------------------- //
    // --------------------- get account bean + trx ----------------------- //
    // -------------------------------------------------------- ------------ //
    public function getAccount()
    {

        $account_ids = $this->_accountCore->getAccountAuthority($_SESSION);
        $sub_id = explode(",", $this->_request->id)[1];
        if ($account_ids && !in_array($sub_id, $account_ids)) {
            throw new Exception("لا يوجد لديك صلاحية لمشاهدة الحساب");
        }
        // get the account info
        $accountBean = $this->_accountCore->getAccount($this->_request->id, $_SESSION['user_id']);
        $accountBean = json_decode($accountBean);

        // prepare search filter
        $filter = $this->prepareFilter();
        $from_date = $this->_request->date_from;
        $to_date = $this->_request->date_to;
        $limit = $this->_request->limit;
        $note = $this->_request->note;
        $statementType = $this->_request->statement_type;
        $searchFilter = [
            ['key' => 'id', 'val' => $accountBean->id],
            ['key' => 'sub_id', 'val' => $accountBean->sub_id],
            ['key' => 'trx_date', 'val' => $from_date, 'op' => 'greater than'],
            ['key' => 'trx_date', 'val' => $to_date, 'op' => 'less than']
        ];
        if ($note) {
            $searchFilter[] = ['key' => 'notes', 'val' => $note, 'op' => 'like'];
        }
        if (!$limit) {
            $limit = 10000;
        }
        if ($statementType) {
            $searchFilter[] = ['key' => 'op', 'val' => $statementType];
        }

        // search DB
        $trx_query = $this->_accountCore->getAccountStatement($searchFilter, $limit, $_SESSION['user_id']);

        // inject the starting balance into account bean
        if ($trx_query->found_rows > 0) {
            $accountBean->starting_balance = $trx_query->data[0]->past_balance;

            // format the trx amount to sort it into Cr or Dr
            foreach ($trx_query->data as &$trx) {

                $trx->trx_date = date("Y-m-d", strtotime($trx->trx_date));

                if ($trx->op == "D")
                    $trx->dr = $trx->amount;
                if ($trx->op == "C")
                    $trx->cr = $trx->amount;
            }
        } else {
            $accountBean->starting_balance = 0;
        }

        // return result
        $result = new stdClass();
        $result->accountBean = $accountBean;
        $result->trx = $trx_query->data;

        parent::response($result);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- get list of accounts based on search filter ------------- //
    // ------------------------------------------------------------------------------- //
    public function searchAccount()
    {
        $filter = $this->prepareFilter();


        // loop on the filter to determine the search value
        foreach ($filter as &$node) {
            if ($node['key'] == "phone") {
                $phone = convertToInternational($node['val']);
                if (substr($phone, 0, 2) === "00") {
                    $phone = "+" . substr($phone, 2, strlen($phone));
                }
                $searchFilter = [['key' => 'phone', 'val' => $phone], ['key' => 'status', 'val' => 'ACTIVE']];
                $userInfo = $this->_userCore->searchUser($searchFilter, 1, 0, 0);
                $node['key'] = "nn";
                $node['val'] = $userInfo->data[0]->nn;
            }
        }

        // call the core search
        $account_qry = $this->_accountCore->searchAccount($filter,  $this->_request->limit, $this->_request->offset, $_SESSION['user_id']);

        parent::response($account_qry);
    }


    // search for list of cash boxes that are allowed for close cash box report
    public function searchCashBoxAccount()
    {

        $tender_id = $this->_request->tender_id;

        // project based report template
        if ($tender_id) {
        $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);

        $filter = $this->prepareFilter();
        $filter[] = ['key' => 'status', 'val' => 'ACTIVE'];
        $filter[] = ['key' => 'type', 'val' => 'CASH'];
 
        // External
        if($tender_id == 8){
            $filter[] = ['key'=>'id','val' => '590000'];
            $filter[] = ['key'=>'sub_id','val' => '19914'];
        }

        // Grains
        else if($tender_id == 13){
            $filter[] = ['key'=>'id','val' => '590000'];
            $filter[] = ['key'=>'sub_id','val' => '19913'];
        }

        // Injaz
        else if($tender_id == 18){
            $filter[] = ['key'=>'id','val' => '590000'];
            $filter[] = ['key'=>'sub_id','val' => '19901'];
        }

        // Fuel
        else if($tender_id == 12){
            $filter[] = ['key'=>'id','val' => '590000'];
            $filter[] = ['key'=>'sub_id','val' => '19919'];
        }

        // cruide_oil
        else if($tender_id == 11){
            $filter[] = ['key'=>'id','val' => '590000'];
            $filter[] = ['key'=>'sub_id','val' => '19917'];
        }
        // nasser
        else if($tender_id == 21){
            $filter[] = ['key'=>'id','val' => '1402067'];
            $filter[] = ['key'=>'sub_id','val' => [19901,19902,19903] , 'op' => 'in'];
        }

        // other
        else{
            $filter[] = ['key' => 'company_id', 'val' => $tenderBean->company_id];
            $filter[] = ['key' => 'id', 'val' => ['590000'], 'op' => 'not in'];
        }


        // call the core search
        $account_qry = $this->_accountCore->searchAccount($filter, 100 , 0, $_SESSION['user_id']  );
        } else {
            $accountFilter = new stdClass();
            $accountFilter->filter = ["type" => "CASH", "status" => "ACTIVE"];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $account_qry =  $this->_fps->searchAccount($accountFilter, $_SESSION['user_id']);
        }


        parent::response($account_qry);
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of accounts based on search filter ------------- //
    // ------------------------------------------------------------------------------- //
    public function searchAdvancePaymentAccounts()
    {
        $accountFilter = $this->prepareFilter();
        if ($this->_request->tender_id == 19) {
            $tempArr = ['key' => "type", 'val' => ["CASH", "AP"], "op" => "in"];
            array_push($accountFilter, $tempArr);
        }

        // call the core search
        $account_qry = $this->_accountCore->searchAccount($accountFilter, 10, 0, $_SESSION['user_id']);

        parent::response($account_qry);
    }

    // --------------------------------------------------------------------------------------- //
    // --------------------- create Sub Account ---------------------------------------------- //
    // --------------------- params tc_id, pa_id, ca_id , $type , account_name --------------- //
    // --------------------------------------------------------------------------------------- //
    public function createSubAccount()
    {

        try {
            // parse incoming params
            $account_id = $this->_request->account_id;
            $tc_id = $this->_request->tc_id;
            $ca_id = $this->_request->ca_id;
            $type = $this->_request->type;

            // validate the ownership of account
            $accountBean = $this->_accountCore->getAccountBasic($account_id, $_SESSION['user_id']);
            if (!$accountBean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            // if the account type is Account Receivable (مطالبة)
            if ($type == "AR") {
                // the request is comming from payment_agent account to open a sub account with trucking account

                if ($accountBean->company_type == "pa" &&  $tc_id) {

                    //  get the pa_id from account
                    $paFilter = [
                        ['key' => 'company_id', 'val' => $accountBean->company_id],
                        ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                    ];
                    $pa_qry = $this->_paymentAgentCore->searchPaymentAgents($paFilter, 1, 0, 0);
                    if ($pa_qry->found_rows == 0) {
                        throw new Exception("Account does not belong to payment agent");
                    }
                    $pa_id = $pa_qry->data[0]->id;

                    //  get the tc_id from account
                    $tc_searchFilter = [
                        ['key' => 'company_id', 'val' => $tc_id],
                        ['key' => 'status', 'val' => 'ACTIVE']
                    ];
                    $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, $_SESSION['user_id']);
                    if ($tc_qry->found_rows == 0) {
                        throw new Exception("Account does not belong to trucking company");
                    }
                    $tc_id = $tc_qry->data[0]->id;

                    // create the financial connection
                    $this->_accountCore->setupFinancialConections_type1($pa_id, $tc_id);
                }
                // the request is comming from trucking account to open a sub account with clearing_agent (owner) account
                else if ($accountBean->company_type == "tc" &&  $ca_id) {

                    //  get the tc_id from account
                    $tc_searchFilter = [
                        ['key' => 'company_id', 'val' => $accountBean->company_id],
                        ['key' => 'status', 'val' => 'ACTIVE']
                    ];
                    $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, $_SESSION['user_id']);
                    if ($tc_qry->found_rows == 0) {
                        throw new Exception("Account does not belong to trucking company");
                    }
                    $tc_id = $tc_qry->data[0]->id;

                    // create the financial connection
                    $ar_account_id = $this->_accountCore->setupFinancialConections_type2($tc_id, $ca_id);

                    // update minimum and maximum balance of the AR account
                    $updateStruct = new stdClass();
                    $updateStruct->id = $ar_account_id;
                    $updateStruct->minimum_balance = $this->_request->minimum_balance;
                    $updateStruct->maximum_balance = $this->_request->maximum_balance;

                    $this->_accountCore->updateAccount($updateStruct, $ar_account_id, $_SESSION['user_id']);
                }
            }
            // if the user wants to create Wallet account or cash
            else if ($type == "WLT" || $type == "CASH" || $type == "BANK") {

                // create the wallet account bean
                $subAccountBean = new stdClass();
                $account_type = $type;
                $account_name = $this->_request->account_name;
                $subAccountBean->id = $accountBean->id;
                $subAccountBean->company_id = $accountBean->company_id;
                $subAccountBean->maximum_balance = $this->_request->maximum_balance;
                $subAccountBean->minimum_balance = $this->_request->minimum_balance;

                $this->_accountCore->createSubAccount($subAccountBean, null, $account_type, $account_name, $_SESSION['user_id']);
            } else {
                throw new Exception("INVALID OPERATION , account type in invalid");
            }

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'ACCOUNT.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------- //
    // --------------------- update account info ----------------------- //
    // ----------------------------------------------------------------- //
    public function updateAccount()
    {

        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER') {
                $allow = true;
            }
        }
        if (!$allow) {
            throw new Exception("لا يوجد لديك صلاحية كافية");
        }

        $accountBean = $this->cleanAccountBean($this->_request);

        $this->_accountCore->updateAccount(
            $accountBean,
            $this->_request->account_id,
            $_SESSION['user_id']
        );

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ACCOUNT.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }

    // --------------------------------------------------------------------------------- //
    // --------------Clear the request and form it to be a valid account bean ---------- //
    // --------------------------------------------------------------------------------- //
    private function cleanAccountBean($request)
    {

        $accountBean = $request;

        // prepare the photos info array
        $accountBean->payment_channel = json_decode(json_encode($request->payment_channel));
        if ($request->maximum_balance == "no_limit") {
            $accountBean->maximum_balance = null;
        }
        if ($request->minimum_balance == "no_limit") {
            $accountBean->minimum_balance = null;
        }

        return $accountBean;
    }

    // --------------------------------------------------------------------------------------------------------------- //
    // ----------------- get a list of financial account for any user or company  grouped by type--------------------- //
    // ----------------- params: account_id -------------------------------------------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------- //
    public function getFinancialAccounts()
    {

        // prepare params
        $account_id = $this->_request->account_id;
        $customFilter = $this->prepareFilter();
        $account_filter = [['key' => 'id', 'val' => $account_id], ['key' => 'status', 'val' => 'ACTIVE']];
        $account_filter = array_merge($account_filter, $customFilter);
        
        $accounts_qry = $this->_accountCore->searchAccount($account_filter, 10000, 0, $_SESSION['user_id'], 'order by sub_id');

        // sort the accounts based on type
        $result = [];
        foreach ($accounts_qry->data as $account) {
            $result[$account->tree_type][] = $account;
        }

        // loop on assessts account and extract AR account
        $result['AR'] = [];

        if ($result['A']) {
            foreach ($result['A'] as $valueKey => $value) {
                if ($value->type == "AR") {
                    array_push($result['AR'], $value);
                    unset($result['A'][$valueKey]);
                }
            }
        }

        // sort the account types
        $result2 = [];
        $account_id = $accounts_qry->data[0]->id . "," . $accounts_qry->data[0]->sub_id;
        $result2['account_bean'] = $this->_accountCore->getAccountBasic($account_id, $_SESSION['user_id']);
        if ($result['A']) {
            $result2['A'] = array_values($result['A']);
        }
        $result2['R'] = $result['R'];
        $result2['EX'] = $result['EX'];
        $result2['OE'] = $result['OE'];
        $result2['L'] = $result['L'];
        $result2['AR'] = $result['AR'];

        // return result
        parent::response($result2);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: company_id, user_id--------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_scoreCards()
    {

        // prepare params
        $id = $this->_request->account_id;

        // search for accounts
        $account_filter = [['key' => 'id', 'val' => $id]];
        $accounts_qry = $this->_accountCore->searchAccount($account_filter, 1000, 0, $_SESSION['user_id']);

        // calculate the summation of the following
        $scoreCards = [];
        foreach ($accounts_qry->data as $account) {
            $scoreCards[$account->type] += $account->balance;
        }

        if (!$scoreCards["AP"]) {
            $scoreCards["AP"] = 0;
        }
        if (!$scoreCards["AR"]) {
            $scoreCards["AR"] = 0;
        }
        if (!$scoreCards["EX"]) {
            $scoreCards["EX"] = 0;
        }
        if (!$scoreCards["R"]) {
            $scoreCards["R"] = 0;
        }

        $result['score_cards'] = $scoreCards;

        // return result
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: company_id, user_id--------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getMobileFinancialSummaryScoreCards()
    {

        // validate auth
        $allow = false;

        $userRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
        foreach ($userRolesArray as $role) {
            if($role == 'TC_FINANCIAL_MANAGER'){
                $allow = true;
            }
        } 
        if(!$allow){
            throw new Exception("لا توجد لديك صلاحية كافية للمتابعة");
        }
  
        // prepare params
        // search for accounts
        $accounts_qry = $this->_accountCore->searchAccount([], 1000, 0, $_SESSION['user_id']);
      
        // calculate the summation of the following
        $scoreCards = [];
        foreach ($accounts_qry->data as $account) {
            $scoreCards[$account->type] += $account->balance;
        }

        if (!$scoreCards["AP"]) {
            $scoreCards["AP"] = 0;
        }
        if (!$scoreCards["AR"]) {
            $scoreCards["AR"] = 0;
        }
        if (!$scoreCards["EX"]) {
            $scoreCards["EX"] = 0;
        }
        if (!$scoreCards["R"]) {
            $scoreCards["R"] = 0;
        }

        $result['score_card_1'] = [
            ["label" => "الايرادات", "value" => number_format($scoreCards['R'], 3)],
                                   ["label" => "غير مقبوض" , "value" => number_format($scoreCards['AR'],3)]
                                  ];
 
        $result['score_card_2'] = [
            ["label" => "المصاريف", "value" => number_format($scoreCards['EX'], 3)],
                                   ["label" => "غير مدفوع" , "value" => number_format($scoreCards['AP'],3)]
                                  ];
 
        // return result
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: account_id , date_from , date_to ------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_cashFlow()
    {

        // parse incoming params
        $account_id = $this->_request->account_id;

        // get the accounts of R, Ex
        $activeAccountStatus = DBConnection::getActiveStatus('account');
        $account_filter = [
            ['key' => 'id', 'val' => $account_id],
            ['key' => 'tree_type', 'val' => ['R', 'EX'], 'op' => 'in'],
            ['key' => 'status', 'val' => $activeAccountStatus, 'op' => 'in']
        ];
        $accounts_qry = $this->_accountCore->searchAccount($account_filter, 1000, 0, $_SESSION['user_id']);

        // get the account statment for the above accounts for the past 5 months        
        for ($i = 0; $i < 12; $i++) {

            $date_from = date('Y-m-1', strtotime("-$i months", strtotime(DBConnection::getSystemDate())));
            $date_to = date('Y-m-t', strtotime($date_from));    // last day of the month
            $obj = [];
            $obj[] = date('Y-m', strtotime("-$i months", strtotime(DBConnection::getSystemDate())));

            $total_revinue = 0;
            $total_expense = 0;
            foreach ($accounts_qry->data as $account) {
                $searchFilter = [
                    ['key' => 'id', 'val' => $account->id],
                    ['key' => 'sub_id', 'val' => $account->sub_id],
                    ['key' => 'trx_date', 'val' => $date_from, 'op' => 'greater than'],
                    ['key' => 'trx_date', 'val' => $date_to, 'op' => 'less than']
                ];

                $trx_query = $this->_accountCore->getAccountStatement($searchFilter, 100000, $_SESSION['user_id']);
                foreach ($trx_query->data as $trx) {

                    $amountSignal = 1;
                    if ($trx->op != $account->cat) {
                        $amountSignal = -1;
                    }
                    if ($account->tree_type == "EX")
                        $total_expense += doubleVal($trx->amount) * $amountSignal;
                    if ($account->tree_type == "R")
                        $total_revinue += doubleVal($trx->amount) * $amountSignal;
                }
            }

            $obj[] = $total_revinue;
            $obj[] = $total_expense;
            $obj[] = doubleVal(number_format((float)$obj[1] - $obj[2], 3, '.', ''));

            $cashFlow[] = $obj;
        }


        $cashFlow = array_reverse($cashFlow);
        array_unshift($cashFlow, ["الشهر", "الايرادات", "المصاريف", "صافي الربح"]);


        parent::response($cashFlow);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary account payables --------------------------------- //
    // ----------------- params: account_id                         ----------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_AP()
    {

        // prepare params
        $account_id = $this->_request->account_id;

        // search for AP accounts
        $activeAccountStatus = DBConnection::getActiveStatus('account');
        $account_filter = [
            ['key' => 'id', 'val' => $account_id],
            ['key' => 'status', 'val' => $activeAccountStatus, 'op' => 'in'],
            ['key' => 'type', 'val' => "AP"]
        ];
        $accounts_qry = $this->_accountCore->searchAccount($account_filter, 1000, 0, $_SESSION['user_id']);

        $apResult = [];
        foreach ($accounts_qry->data as $account) {
            $apResult[$account->name] += $account->balance;
        };

        $result = [];
        foreach ($apResult as $key => $value) {
            $result[] = [$key, $value];
        }

        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary account receivable ------------------------------- //
    // ----------------- params: account_id                         ----------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummary_AR()
    {
        // prepare params
        $account_id = $this->_request->account_id;

        // search for AP accounts
        $activeAccountStatus = DBConnection::getActiveStatus('account');
        $account_filter = [
            ['key' => 'id', 'val' => $account_id],
            ['key' => 'status', 'val' => $activeAccountStatus, 'op' => 'in'],
            ['key' => 'type', 'val' => "AR"]
        ];
        $accounts_qry = $this->_accountCore->searchAccount($account_filter, 1000, 0, $_SESSION['user_id']);

        $arResult = [];
        foreach ($accounts_qry->data as $account) {
            $arResult[$account->name] += $account->balance;
        };

        $result = [];
        foreach ($arResult as $key => $value) {
            $result[] = [$key, $value];
        }

        parent::response($result);
    }


    private function createDateRangeArray($strDateFrom, $strDateTo)
    {
        $aryRange = array();

        $iDateFrom = mktime(1, 0, 0, substr($strDateFrom, 5, 2),     substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
        $iDateTo = mktime(1, 0, 0, substr($strDateTo, 5, 2),     substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

        if ($iDateTo >= $iDateFrom) {
            array_push($aryRange, date('m-d', $iDateFrom)); // first entry
            while ($iDateFrom < $iDateTo) {
                $iDateFrom += 86400; // add 24 hours
                array_push($aryRange, date('m-d', $iDateFrom));
            }
        }
        return $aryRange;
    }


    // ------------------------------------------------------------------------------------------------ //
    // ----------------- get a the financial summary for a certain company or user--------------------- //
    // ----------------- params: account_id , date_from , date_to ------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getFinancialSummaryForAccount()
    {

        // parse incoming params
        $account_id = $this->_request->account_id;
        $sub_id = $this->_request->sub_id;
        $from_date = $this->_request->from_date;
        $to_date = $this->_request->to_date;


        $query = "select date_format(t.create_date,'%Y-%m-%d') trx_date,t.current_balance
                from jv_trx t
                where id in(
                select max(jv_trx.id)
                from jv_trx join jv on jv.id=jv_trx.jv_id
                where (jv_trx.account_id,jv_trx.sub_id)=(?,?)
                    and jv_trx.create_date between ? and ?
                group by date_format(date,'%Y%m%d')
                )
                ";
        $param = [$account_id, $sub_id, $from_date, $to_date];
        $trx_query = DBConnection::runBindDatabaseQuery($query, $param);

        // search DB


        // fill a map with days of all interval
        $dates = $this->createDateRangeArray($from_date, $to_date);

        // loop on trx and get the last balance of each date in the previos array
        $cashFlow = [];
        if ($dates[0] != $trx_query[0]->trx_date) {
            $create_date = $from_date . ' 23:59:59.999';
            $trialBalance = $this->_accountCore->getTrialBalance($account_id, $create_date);
            $initial_balance = 0;
            foreach ($trialBalance as $trialBalanceSubId) {
                if ($trialBalanceSubId->sub_id == $sub_id) {
                    $initial_balance = intVal($trialBalanceSubId->balance);
                }
            }
        } else {
            $initial_balance = $trx_query[0]->current_balance;
        }
        foreach ($dates as $day) {
            $obj = [];
            $obj[$day] = $initial_balance;
            foreach ($trx_query as $index => $trx) {
                $date = date_create($trx->trx_date);
                $temp_date = date_format($date, "m-d");
                if ($temp_date == $day) {
                    $obj[$day] = intVal($trx->current_balance);
                    $initialBlance = intVal($trx->current_balance);
                }
            }
            $cashFlow[] = $obj;
        }
        // format data
        $result = [];
        foreach ($cashFlow as $obj) {
            foreach ($obj as $key => $data) {
                $result[] = [$key, $data];
            }
        }

        parent::response($result);
    }

    // -------------------------------------------------------------------------------------------------------------------- //
    // ----------------- withdraw amount of money from a cap account ) ---------------------------------------------------- //
    // ----------------- also this withdraw will decrease certain assets account (like Wallet, Cash ----------------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function withdrawAssetsBalance()
    {
        try {

            DBConnection::startTransaction();

            // prepare params
            $capital_account_id = $this->_request->capital_account_id;
            $asset_account_id = $this->_request->asset_account_id;
            $amount = $this->_request->amount;
            $remarks = $this->_request->remarks;

            // validate the ownership of account
            $asset_account_bean = $this->_accountCore->getAccountBasic($asset_account_id, $_SESSION['user_id']);
            if (!$asset_account_bean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }
            // validate the ownership of account
            $capital_account_bean = $this->_accountCore->getAccountBasic($capital_account_id, $_SESSION['user_id']);
            if (!$capital_account_bean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            // create deposite JV
            $this->_paymentCore->withdrawAssetsBalance($capital_account_bean, $asset_account_bean, $amount, $remarks, $_SESSION['user_id']);

            DBConnection::commitTransaction();

            // return result
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'ACCOUNT.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------------------------------------- //
    // ----------------- deposite amount of money in a certain assets account (like Wallet, Cash) -------------- //
    // ----------------- also this deposite will increase the CAP account of the company ----------------------- //
    // ----------------- params: account_id, amount                          ----------------------------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function depositeAssetsBalance()
    {

        try {

            DBConnection::startTransaction();

            // prepare params
            $capital_account_id = $this->_request->capital_account_id;
            $asset_account_id = $this->_request->asset_account_id;
            $amount = $this->_request->amount;
            $remarks = $this->_request->remarks;

            // validate the ownership of account
            $asset_account_bean = $this->_accountCore->getAccountBasic($asset_account_id, $_SESSION['user_id']);
            if (!$asset_account_bean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }
            // validate the ownership of account
            $capital_account_bean = $this->_accountCore->getAccountBasic($capital_account_id, $_SESSION['user_id']);
            if (!$capital_account_bean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            // create deposite JV
            $this->_paymentCore->depositeAssetsBalance($capital_account_bean, $asset_account_bean, $amount, $remarks, $_SESSION['user_id']);

            DBConnection::commitTransaction();

            // return result
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'ACCOUNT.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------ //
    // ----------------- move amount of money from an assets account (like Wallet, Cash) -------------- //
    // ----------------- to another assets account (like Wallet, Cash) -------------------------------- //
    // ----------------- params: from_account_id, to_account_id , amount       ------------------------ //
    // ------------------------------------------------------------------------------------------------ //
    public function moveBalanceBetweenAccounts()
    {

        try {
            DBConnection::startTransaction();

            // prepare params
            $from_account_id = $this->_request->from_account_id;
            $to_account_id = $this->_request->to_account_id;
            $amount = $this->_request->amount;
            $remarks = $this->_request->remarks;
            $remarks = str_replace("↵", '\n', $remarks); // remove new lines

            // validate the ownership of the 2 accounts
            $fromAccountBean = $this->_accountCore->getAccountBasic($from_account_id, $_SESSION['user_id']);
            if (!$fromAccountBean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }
            $toAccountBean = $this->_accountCore->getAccountBasic($to_account_id, $_SESSION['user_id']);
            if (!$toAccountBean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            // create deposite JV
            $this->_paymentCore->moveBalanceBetweenAccounts($fromAccountBean, $toAccountBean, $amount, $remarks, $_SESSION['user_id']);

            DBConnection::commitTransaction();

            // return result
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'ACCOUNT.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------------------------------------ //
    // ------------- Create Sub-account of type cash for certain payment agent when it is created from trucking company ------------- //
    // ------------- then deposite certain amount in payment agent CAP account then transfer it to the new cash account ------------- //
    // ------------- params: pa_id, account_name, amount --------------------------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------ //
    public function createCashSubAccountForPaymentAgent()
    {

        try {

            DBConnection::startTransaction();

            // parse incoming params
            $pa_id = $this->_request->pa_id;
            $account_name = $this->_request->account_name;
            $amount = $this->_request->amount;

            // get the pa bean
            $pa_bean = $this->_paymentAgentCore->getPaymentAgentBasic($pa_id, $_SESSION['user_id']);
            if (!$pa_bean) {
                throw new Exception("لا يوحد لديك صلاحية للمتابعة");
            }

            // validate the request is comming from company
            if (!$_SESSION['company_id']) {
                throw new Exception("لا يوحد لديك صلاحية للمتابعة");
            }

            // get the pa account bean
            $activeAccountStatus = DBConnection::getActiveStatus('account');
            $pa_account_filter = [
                ['key' => 'company_id', 'val' => $_SESSION['company_id']],
                ['key' => 'type', 'val' => 'CAP'],
                ['key' => 'status', 'val' => $activeAccountStatus, 'op' => 'in']
            ];
            $pa_accounts_qry = $this->_accountCore->searchAccount($pa_account_filter, 100, 0, $_SESSION['user_id']);
            foreach ($pa_accounts_qry->data as $capAccount) {
                $temp = $this->_accountCore->getAccountBasic($capAccount->id . "," . $capAccount->sub_id, $_SESSION['user_id']);
                if ($temp->company_type == "pa") {
                    $paAccountBean = $temp;
                    break;
                }
            }
            if (!$paAccountBean) {
                throw new Exception("لم يتم تعريف حساب مكتب الصرف");
            }

            // create sub account CASH for pa
            $subAccountBean = new stdClass();
            $subAccountBean->id = $paAccountBean->id;
            $subAccountBean->company_id = $_SESSION['company_id'];
            $subAccountBean->minimum_balance = 0;
            $cashAccount_id = $this->_accountCore->createSubAccount($subAccountBean, null, "CASH", $account_name, $_SESSION['user_id']);

            // deposite the assets in CAP
            //$this->_paymentCore->depositeAssetsBalance($cashAccount_id, $amount, $_SESSION['user_id']);

            // transfer the money to the new cash
            //$this->_paymentCore->moveBalanceBetweenAccounts($paAccountBean, $subAccount_id, $amount, $_SESSION['user_id']);

            DBConnection::commitTransaction();

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'ACCOUINT.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------- //
    // ----------------- Search for accounts for TC, PA, CA accounts --------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function searchCompanyAccounts()
    {

         // search for PLC accounts for companies
        $activeAccountStatus = DBConnection::getActiveStatus('tender');
        $account_filter = [
            ['key' => 'company_id', 'op' => 'is not null'],
            ['key' => 'type', 'val' => 'PLC'],
            ['key' => 'status', 'val' => $activeAccountStatus, 'op' => 'in']
        ];
 
        if (strtoupper($_SESSION['type']) == "CORPORATE") {
            $customFilter = [['key' => 'company_id', 'val' => $_SESSION['company_id']]];
        } else {
            $customFilter = $this->prepareFilter();
        }

        $account_filter = array_merge($account_filter, $customFilter);
        $accountQry = $this->_accountCore->searchAccount($account_filter, 100000, 0, $_SESSION['user_id'], ' order by name');

        $result = [];
        // loop on result to format it
        foreach ($accountQry->data as $account) {
            $accountResult = new stdClass();
            $accountResult->id = $account->id;
            $accountResult->name = $account->name;
            $accountResult->company_id = $account->company_id;
            $accountResult->company_type = $account->company_type;

            $result[] = $accountResult;
        }

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['data'] = $result;
        parent::response($Result);
    }

    // ------------------------------------------------------------------------- //
    // ------------------- change status of account ---------------------------- //
    // ------------------------------------------------------------------------- //
    public function changeStatus()
    {

        try {

            //parse params
            $account_id = $this->_request->account_id;
            $new_status = $this->_request->new_status;

            // validate the ownership of the account
            $accountBean = $this->_accountCore->getAccountBasic($account_id, $_SESSION['user_id']);
            if (!$accountBean) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            // call core to change status
            $this->_accountCore->changeStatus($accountBean, $new_status, $_SESSION['user_id']);

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'ACCOUNT.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }




    // --------------------------------------------------------------------------------- //
    // ---------------- Get list of accounts to be used in payment --------------------- //
    // --------------------------------------------------------------------------------- //
    public function getPaymentAccounts()
    {

        //parse params
        $payment_method = $this->_request->payment_method;
        $tender_id = $this->_request->tender_id;
        $tenderManafist = $this->_tenderCore->getTenderManifest($tender_id, 0);

        // get available accounts from manifest
        $payment_accounts = $tenderManafist['freight']['payment_accounts'];
        if (!$payment_accounts) $payment_accounts = [];

        // filter these accounts
        $account_ids = [];
        $account_sub_ids = [];
        foreach ($payment_accounts as $payment_acc) {
            if (strtoupper($payment_acc['payment_method']) == strtoupper($payment_method)) {
                $account_ids[] = $payment_acc['account_id'];
                $account_sub_ids[] = $payment_acc['account_sub_id'];
            }
        }

        $account_filter = [];
        $account_filter[] = ['key' => 'id', 'val' => $account_ids, 'op' => 'in'];
        $account_filter[] = ['key' => 'sub_id', 'val' => $account_sub_ids, 'op' => 'in'];
        $accounts_qry = $this->_accountCore->searchAccount($account_filter, 10, 0, 0);

        parent::response($accounts_qry);
    }


    // --------------------------------------------------------------------------------------//
    // ------------------- Search voucher from accounts name --------------------------------//
    // --------------------------------------------------------------------------------------//
    public function searchVoucherFromAccount()
    {

        // minagate
        if ($_SESSION['employee_id']) {
            $query = "select distinct(from_account) , from_name from voucher_view where create_date > '2020-01-01' and from_name != 'null'";
            $param = [];
            $accountResult = DBConnection::runBindDatabaseQuery($query, $param);
        } else {
            // get company account bean
            $account_filter = [['key' => 'company_id', 'val' => $_SESSION['company_id']]];
            $accountqry = $this->_accountCore->searchAccount($account_filter, 100, 0, 0);
            $account_ids = [];
            foreach ($accountqry->data as $acc) {
                $account_ids[] = "'" . $acc->id . "," . $acc->sub_id . "'";
            }
            $account_ids_string = join(',', $account_ids);

            $query = "select distinct(from_account) , from_name from voucher_view where create_date > '2020-01-01' and from_account in ($account_ids_string)";

            $param = [];
            $accountResult = DBConnection::runBindDatabaseQuery($query, $param);
        }

        parent::response($accountResult);
    }

    // ------------------------------------------------------------------------------------//
    // ------------------- Search voucher to accounts name --------------------------------//
    // ------------------------------------------------------------------------------------//
    public function searchVoucherToAccount()
    {

        $query = "SELECT DISTINCT(to_account),
                        JSON_UNQUOTE(JSON_EXTRACT(trx_template, '$.phone')) phone,
                        to_name
                    FROM
                        voucher_view v
                    WHERE
                        create_date > '2020-01-01'";
        $param = [];
        $accountResult = DBConnection::runBindDatabaseQuery($query, $param);

        parent::response($accountResult);
    }

    // --------------------------------------------------------------------------//
    // ------------------- Search trx stattment  --------------------------------//
    // --------------------------------------------------------------------------//
    public function searchTrxStatment()
    {

        $trx_id = $this->_request->trx_id;
        $jv_id = $this->_request->jv_id;

        if ($trx_id) {
            $query = "SELECT jv_id,
                    a.name,
                    jv_trx.account_id,
                    jv_trx.sub_id,
                    jv_trx.amount,
                    jv_trx.op,
                    jv_trx.create_date,
                    jv_trx.notes,
                    jv_trx.update_by
                FROM jv_trx join account a
                    on a.id=jv_trx.account_id
                            and a.sub_id=jv_trx.sub_id
                WHERE jv_id = (select jv_id from jv_trx where id = ?)";
            $param = [$trx_id];
        } else if ($jv_id) {
            $query = "SELECT jv_id,
                            a.name,
                            jv_trx.account_id,
                            jv_trx.sub_id,
                            jv_trx.amount,
                            jv_trx.op,
                            jv_trx.create_date,
                            jv_trx.notes,
                            jv_trx.update_by
                        FROM jv_trx join account a
                            on a.id=jv_trx.account_id
                                    and a.sub_id=jv_trx.sub_id
                        WHERE jv_id = ?";
            $param = [$jv_id];
        }
        $accountResult = DBConnection::runBindDatabaseQuery($query, $param);

        $result = [];
        foreach ($accountResult as $row) {
            $result['info']['jv_id'] = $row->jv_id;
            $result['info']['create_date'] = $row->create_date;

            $trx = [];
            $trx["account_name"] = $row->name;
            $trx["account_number"] = $row->account_id . "-" . $row->sub_id;
            $trx["notes"] = $row->notes;
            $trx["update_by"] = $this->_userCore->getUserBasic($row->update_by, 0)->name;
            if ($row->op == "C") {
                $trx['credit'] = $row->amount;
                $trx['debit'] = 0;
            } else if ($row->op == "D") {
                $trx['debit'] = $row->amount;
                $trx['credit'] = 0;
            }
            $result['trx'][] = $trx;
        }
        parent::response($result);
    }



    // --------------------------------------------------------------------------//
    // ------------------- Search trx stattment  --------------------------------//
    // --------------------------------------------------------------------------//
    public function searchTrialBalance()
    {

        $account_id = $this->_request->account_id;
        $create_date = $this->_request->create_date . ' 23:59:59.999';

        $accountResult = $this->_accountCore->getTrialBalance($account_id, $create_date);

        parent::response($accountResult);
    }

    

    // -----------------------------------------------------------------------------------------//
    // ------------------- create manual transaction on expense account ------------------------//
    // -----------------------------------------------------------------------------------------//
    public function createManualTransaction()
    {
        try {
            // validate add manual JV , it should be on expense acount only
            $from_account = $this->_request->from_account;
            $to_account = $this->_request->to_account;
            $operation_type = $this->_request->operation_type;
            if ($operation_type == "credit") {
                $operation_type = "C";
                $inverse_operation_type = "D";
            } else {
                $operation_type = "D";
                $inverse_operation_type = "C";
            }
            $amount = $this->_request->amount;
            $notes = escapeJsonString($this->_request->notes);
            $ledger_account_id = $this->_request->account_id;

            $from_account = str_replace(",", "-", $from_account);
            $to_account = str_replace(",", "-", $to_account);

            $jv_trx = [];
            $jv_trx[] = array(
                "account" => $from_account,
                "amount" => $amount,
                "op" => $operation_type,
                "notes" => $notes
            );
            $jv_trx[] = array(
                "account" => $to_account,
                "amount" => $amount,
                "op" => $inverse_operation_type,
                "notes" => $notes
            );

            $jv_date = $this->_request->jv_date;
            $this->_paymentCore->addJV($ledger_account_id, $jv_date, $jv_trx, $notes, 0);

            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'ACCOUNT.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

     // ------------------------------------------------------------------------------------ //
    // ------------------ getCashBoxLogDetails  ------------------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function getCashBoxLogDetails()
    {
        try {
            $limit = $this->_request->limit;
            $offset = $this->_request->offset;
            $cash_box_log_filter =  $this->prepareFilter();
            $filter = [];
            foreach ($cash_box_log_filter as $key =>  &$value) {
                if ($value["key"] == "create_date" && $value["val"] == "") {
                    unset($cash_box_log_filter[$key]);
                }
            }
            $searchCashBoxLog_qry = $this->_accountCore->searchCashBoxLog($cash_box_log_filter,  $limit, $offset, $_SESSION['user_id'], "order by id desc");
            parent::response($searchCashBoxLog_qry->data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------ Depricated Methods -----------------------------------------------------

    // ------------------------------------------------------------------------------- //
    // --------------------- get list of accounts based on search filter ------------- //
    // ------------------------------------------------------------------------------- //
    public function getAccountShares()
    {

        // // get user/company bean account
        // $user_id = $this->_request->user_id;
        // $company_id = $this->_request->company_id;

        // if($user_id){
        //     $account_filter = [['key'=>'user_id','val' => $user_id]];
        //     $accountBean = $this->_accountCore->searchAccount($account_filter,1,0,0)->data[0];
        //     $account_id = $accountBean->id;
        // }
        // else if($company_id){
        //     $account_filter = [['key'=>'company_id','val' => $company_id]];
        //     $accountBean = $this->_accountCore->searchAccount($account_filter,1,0,0)->data[0];
        //     $account_id = $accountBean->id;
        // }

        // // get all active tenders
        // $activeTenderStatus = DBConnection::getActiveStatus('tender');
        // $tenderSearchFilter = [['key'=>'status','val' => $activeTenderStatus , 'op'=>'in']];
        // $tenderResult = $this->_tenderCore->searchTender($tenderSearchFilter,100,0,0);

        // // get all main liability accounts
        // $mainLiabilityTender = [];
        // foreach ($tenderResult->data as $tender) {
        //     $tenderAccount = $this->_tenderCore->getTenderAccounts($tender->id);
        //     if($tenderAccount['main_liability_account']){
        //         $tenderObj = new stdClass();
        //         $tenderObj->MLA = $tenderAccount['main_liability_account'];
        //         $tenderObj->tender_name = $tender->tender_name;
        //         $mainLiabilityTender[] = $tenderObj;
        //     }
        // }

        // $result = [];
        // //get the trx that have mainLiabilityAccount as part of it (userAccount => mainLiabilityAccount )
        // foreach ($mainLiabilityTender as $tender) {
        //     $sql = "
        //         SELECT
        //             *
        //         FROM
        //             account_trx trx
        //         WHERE
        //             trx.from_account = ?
        //             AND trx.to_account = ?";

        //     $param = [$account_id,$tender->MLA];
        //     $trx_result = DBConnection::runBindDatabaseQuery($sql,$param);
        //     $totalAmount = 0;
        //     foreach ($trx_result as $trx) {
        //         $totalAmount += $trx->amount;
        //     }

        //     //get the trx mainLiabilityAccount => userAccount in order to deduct it
        //     $sql = "
        //         SELECT
        //             *
        //         FROM
        //             account_trx trx
        //         WHERE
        //             trx.from_account = ?
        //             AND trx.to_account = ?";

        //     $param = [$tender->MLA,$account_id];
        //     $trx_result2 = DBConnection::runBindDatabaseQuery($sql,$param);
        //     foreach ($trx_result2 as $trx) {
        //         $totalAmount -= $trx->amount;
        //     }
        //     if($totalAmount > 0){
        //         $project1 = new stdClass();
        //         $project1->project_name = $tender->tender_name;
        //         $project1->amount = $totalAmount;
        //         $result[] = $project1;
        //     }
        // }
        // parent::response($result);
    }

    // -------------------------------------------------------------------------------------------------- //
    // ----------------- get account statment for report "كشف الحسابات" --------------------------------- //
    // ----------------- params: tender_id, account_id, from_date, to_date, limit ----------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function getAccountStatement()
    {

        //     // prepare params
        //     $tender_id = $this->_request->tender_id;
        //     $account_id = $this->_request->account_id;
        //     $from_date = $this->_request->from_date;
        //     $to_date = $this->_request->to_date;
        //     $note = $this->_request->note;
        //     $limit = $this->_request->limit;

        //     // validate auth
        //     $user_roles = explode(",",$_SESSION['USER_ROLES']);
        //     $allowedToViewReport = $this->_accountCore->hasAuthToViewFinancialReport($tender_id, "account_statement_report", $user_roles);
        //     if(!$allowedToViewReport){
        //         throw new Exception("لا توجد لديك صلاحية للمتابعة");
        //     }

        //     // prepare filter

        //     $data = $this->_accountCore->getAccountStatement($account_id,$from_date,$to_date,$limit,$note);

        //     // return result
        //     $result = new stdClass();
        //     $result->data = $data;
        //     $result->found_rows = sizeof($data);
        //     parent::response($result);
    }


    

   
}


$account_interface = new Account_interface();
