<?php
error_reporting(E_ALL | E_PARSE);

require_once(dirname(__FILE__) . "/../outgoing_integration/mg_tracking.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/container.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");

// init object
$userCore = new UserCore();
$mg_tracking = new  MG_tracking();
$waybillCore = new WaybillCore();

try {

    // get input params    
    // $locations = json_decode($_POST['locations']);
    // $device_id = $locations[0]->device_id;

    $device_id = "70667f45a32bc791";
    $location = new stdClass();
    $location->long = 29.6760922;
    $location->lat = 29.6760922;
    $location->location_date = "2022-05-30";
    $locations = [$location];


    if (!$device_id) {
        echo ("device_id is required");
        die;
    }
    if (!$locations) {
        echo ("locations is required");
        die;
    }

    // get user that has this device id
    $searchFilter = [['key' => 'hb', 'val' => [$device_id], 'op' => 'json in', 'node' => '$[0].UUID']];
    $userInfo = $userCore->searchUser($searchFilter, 1, 0, 0);

    if ($userInfo->found_rows > 0) {

        $userBean = $userInfo->data[0];

        // get waybill info for this user
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $waybillFilter = [
            ['key' => 'driver_id', 'val' => $userBean->driver_id],
            ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in']
        ];
        $waybill_result = $waybillCore->searchWaybills($waybillFilter, 1, 0, 0);

        if ($waybill_result->found_rows > 0) {
            // prepare data for tracking 
            $waybillBean = $waybill_result->data[0];
            $trip_details = [];
            $tn = $waybillBean->tn;
            $wn = $waybillBean->wn;

            // save the location on tracking system
            $mg_tracking->saveLocations($device_id, $userBean->id, $locations, $wn, $tn , null , null);
            
        } else {
            // get land_trip info for this user
            $userBean->nn = 9771048270;
            
            $userFilter = ['nn' => $userBean->nn, 'status_in' => ["ACTIVE", "NEW", "ONROAD"]];
            $data = new stdClass();
            $data->filter = $userFilter;
            $data->limit = 1;
            $data->offset = 0;
            $con = new Container();
            $landTripsResult = $con->searchLandTrip($data, 0);

            if ($landTripsResult['found_rows'] > 0) {
                // prepare data for tracking 
                $land_trip_Bean = $landTripsResult['data'][0];
                $document = json_decode($land_trip_Bean['document']);
                $tn = $document->carrier[0]->truck->tn;
                $land_trip = $land_trip_Bean['serial'];

                // $landTripDetails = new stdClass();
                // $landTripDetails->declaration_number = $land_trip_Bean['declaration_number'];
                // $landTripDetails->cid = $land_trip_Bean['cid'];

                // save the location on tracking system
                $mg_tracking->saveLocations($device_id, $userBean->id, $locations, null, $tn , $land_trip, null);
            }
        }
    } else {
        echo "invalid device_id";
        die;
    }
} catch (Exception $e) {
    echo "error: " . $e->getMessage();
}

echo "done";
