<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../outgoing_integration/mg_tracking.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../waybill/waybill_core.php");

require_once (dirname(__FILE__)."/../../includes/util.php");


class GPS_interface extends API{

    // the request of each call
    private $_request = array();
    private $_userCore;
    private $_waybillCore;

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();
        session_start();
        if( !isset($_SESSION['user_id'])){
            //throw new Exception('No Session!');
        }

        // init the object
        $this->_mg_tracking = new MG_tracking();
        $this->_userCore = new UserCore();
        $this->_waybillCore = new WaybillCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ----------------------------------------------------------------------------------- //
    // ---------------------- save the location of a certain truck ----------------------- //
    // ----------------------------------------------------------------------------------- //
    public function saveLocations(){

        // get input params
        $device_id  = $this->_request->device_id;
        $locations  = $this->_request->locations;
 
        // get user that has this device id
        $searchFilter= [['key' => 'hb', 'val' => [$device_id], 'op' => 'json in', 'node' => '$[0].UUID']];

        $userInfo = $this->_userCore->searchUser($searchFilter,1,0,0);
        if($userInfo->found_rows > 0){
            // get waybill info for this user
            $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
            $userBean = $userInfo->data[0];
            $waybillFilter = [['key'=>'driver_id','val' => $userBean->driver_id],
                              ['key'=>'status','val' => $activeWaybillStatus, 'op' => 'in']
                             ];
            $waybill_result = $this->_waybillCore->searchWaybills($waybillFilter,1,0,0) ;

            if($waybill_result->found_rows == 0){
                throw new Exception("invalid waybill");
            }

            // prepare data for tracking
            $waybillBean = $waybill_result->data[0];
            $tn = $waybillBean->tn;
            $wn = $waybillBean->wn;

            // save the location on tracking system
            $this->_mg_tracking->saveLocations($device_id, $userBean->id , $locations , $wn, $tn);

        }else{
            throw new Exception("invalid device_id");            
        }

       //return Success reponse
       $Result['ERRORCODE'] = "0";
       $Result['MESSAGE'] = "PUBLIC.SUCCESSFUL_OPERATION";
       parent::response($Result);

    }

}

$gps_interface = new GPS_interface();
