<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../vendor/autoload.php';

use Google\Cloud\Tasks\V2\Task;
use Google\Cloud\Tasks\V2\CloudTasksClient;
use Google\Protobuf\Timestamp;
use Google\Cloud\Tasks\V2\HttpMethod;
use Google\Cloud\Tasks\V2\HttpRequest;
use Google\Cloud\Tasks\V2\AppEngineHttpRequest;
use Google\Cloud\Tasks\V2\AppEngineRouting;
use Google\Protobuf\Internal\MapField;
use Google\Protobuf\Internal\GPBType;


require_once(dirname(__FILE__) . "/GCPTask.php");

class GCPTask_core
{
    const PROJECT = "waybill-system";
    const LOCATION = "us-central1";
    const SERVICE = "api";

    public function pushTask($task_name, $queue_name, $cb_url, $cb_data, $delay)
    {

        $GCPTask = new GCPTask();
        $GCPTask->setName($task_name)
            ->setQueueName($queue_name)
            ->setCbData($cb_data)
            ->setCbUrl($cb_url)
            ->setDelay($delay);

        $client = new CloudTasksClient();
        // Prepare callback request
        $headers = new MapField(GPBType::STRING, GPBType::STRING);
        $headers->offsetSet("Referer", "http://api.minagate.com/");
        $headers->offsetSet("Content-Type", "application/x-www-form-urlencoded");
        $headers->offsetSet("Accept", "application/json");

        // Get Queue name
        $queueName = $client::queueName(self::PROJECT, self::LOCATION, $GCPTask->getQueueName());

        // Create G-Cloud task
        $taskName = $client::taskName(self::PROJECT, self::LOCATION, $GCPTask->getQueueName(), ($GCPTask->getName() ?? "task_") . "_" . uniqid());
        $task = new Task();
        // Set delay in seconds
        $delay = new Timestamp();
        $delay->setSeconds($this->getTime() + $GCPTask->getDelay());
        $task->setScheduleTime($delay);

        // Set task name
        $task->setName($taskName);

        // check if the callback url is for a remote call or local
        if (substr($GCPTask->getCbUrl(), 0, 4) === "http") {
            // Send normal http call if the cb was remote
            $request = new HttpRequest();
            $request->setUrl($GCPTask->getCbUrl())
                ->setBody(json_encode($GCPTask->getCbData()))
                ->setHttpMethod(HttpMethod::POST)
                ->setHeaders($headers);
            $task->setHttpRequest($request);
        } else {
            // Set app engine routing to reach this service
            $appEngineRouting = new AppEngineRouting();
            //@todo[] get host dynamically

            $appEngineRouting->setHost(getenv("APP_URL"))->setService(self::SERVICE);
            // Send app engine http call if the cb was local to the service
            $appEngineRequest = new AppEngineHttpRequest();
            $appEngineRequest->setHeaders($headers)
                ->setBody(json_encode($GCPTask->getCbData()))
                ->setHttpMethod(HttpMethod::POST)
                ->setRelativeUri("/" . $GCPTask->getCbUrl()) // should start with '/'
                ->setAppEngineRouting($appEngineRouting);

            $task->setAppEngineHttpRequest($appEngineRequest);
        }

        // Create task
        try {
            $client->createTask($queueName, $task);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    /**
     * Get system time
     * @param bool $formatted
     * @return int|string time in seconds or in formatted string
     */
    public function getTime(bool $formatted = null)
    {
        if ($formatted) return date("Y-m-d H:i:s");
        else {
            return time();
        }
    }
}
