<?php

class GCPTask
{

    /**
     * @var string task name
     */
    private $name;

    /**
     * @var string $queueName GCP Queue name to push Task into
     */
    private $queueName;

    /**
     * @var string $cbUrl Local Url that the task should call when executed
     */
    private $cbUrl;
    /**
     * @var array $cbData Data that the task will send with the callback request
     */
    private $cbData;

    /**
     * @var int $delay task delay in seconds
     */
    private $delay = 0;

    public static function create()
    {
        return new self();
    }
    /**
     * @return string $queueName GCP Queue name to push Task into
     */
    public function getQueueName(): string
    {
        return $this->queueName;
    }

    /**
     * @param string $queueName GCP Queue name to push Task into
     * @return GCPTask
     */
    public function setQueueName(string $queueName): GCPTask
    {
        $this->queueName = $queueName;
        return $this;
    }

    /**
     * @return string $cbUrl Local Url that the task should call when executed
     */
    public function getCbUrl(): string
    {
        return $this->cbUrl;
    }

    /**
     * @param string $cbUrl
     * @return GCPTask
     */
    public function setCbUrl(string $cbUrl): GCPTask
    {
        $this->cbUrl = $cbUrl;
        return $this;
    }

    /**
     * @return array
     */
    public function getCbData(): array
    {
        return $this->cbData;
    }

    /**
     * @param array $cbData
     * @return GCPTask
     */
    public function setCbData(array $cbData): GCPTask
    {
        $this->cbData = $cbData;
        return $this;
    }

    /**
     * @return int
     */
    public function getDelay(): int
    {
        return $this->delay;
    }

    /**
     * @param int $delay
     * @return GCPTask
     */
    public function setDelay(int $delay): GCPTask
    {
        $this->delay = $delay;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     * @return GCPTask
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }


    /**
     * @param string $date date in string format
     * @return GCPTask
     */
    public function setDelayUntilDate(string $date)
    {
        $dateInSeconds = strtotime($date);
        $delay = $dateInSeconds - $this->getTime();
        return $this->setDelay($delay);
    }


    /**
     * Get system time
     * @param bool $formatted
     * @return int|string time in seconds or in formatted string
     */
    public static function getTime(bool $formatted = null)
    {
        if ($formatted) return date("Y-m-d H:i:s");
        else {
            return time();
        }
    }


    /**
     * Converts the class to array
     * @inheritDoc
     * @return array
     */
    public function toArray(): array
    {
        return [
            "queue" => $this->getQueueName(),
            "delay" => $this->getDelay(),
            "cb_data" => $this->getCbData(),
            "cb_url" => $this->getCbUrl(),
            "name" => $this->getName(),
        ];
    }
}
