<?php

// import required classes
require_once (dirname(__FILE__)."/dbr_core.php");
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__) . "/../truck/truck_core.php");
 

// DBR = Debit Burden Ration
class DBR_interface extends API{

    // the request of each call
    private $_request = array();
    private $_dbrCore;
    private $_truckCore;

    public function __construct(){
        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();
        
        if( !isset($_SESSION['user_id'])){
            throw new Exception("NO_SESSION",1);
        }

        // init the DriverCore object
        $this->_dbrCore = new DBR_Core();
        $this->_truckCore = new TruckCore();
        
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ------------------------------------------------------------------------------------------------- //
    // ----------- Calculate DBR for certain object (ex: truck or driver ) ----------------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function calculateDBR(){

        // get user input
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        $object_code = $this->_request->object_code;

        // get the truck bean, for ownership validation
        $truckFilter = [['key'=>'tn','val' => $tn]];
        $truck_result = $this->_truckCore->searchTrucks($truckFilter,1,0,$_SESSION['user_id']);
        if($truck_result->found_rows == 0){
            throw new Exception("لا يوجد لديك صلاحية للمتابعة أو ان الشاحنة غير صحيحة");            
        }

        // depends on the requested object, the system will calculate the DBR value
        switch ($object_code) {
            case 'waybill':
                $dbr_result = $this->_dbrCore->calculateWaybillDBR($tn,$tender_id);break;

            case 'tn': // (on later stage) 
            case 'driver_nn': // (on later stage)
        }
        
        //return reponse
        parent::response($dbr_result);
    }


    // ------------------------------------------------------------------------------- //
    // ----------- Calculate the amount to be paid for a certain truck --------------- //
    // ------------------------------------------------------------------------------- //
    public function getTruckDownPayment(){

        // get user input
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
       
        // calculate amount
        $downpayment_value = $this->_dbrCore->calculateTruckDownPayment($tn,$tender_id);

        //return reponse
        parent::response($downpayment_value);
    }
    

}

new DBR_interface();