<?php
require_once(dirname(__FILE__) . "/../includes/Captions.php");
require_once(dirname(__FILE__) . "/../includes/debug.php");
require_once(dirname(__FILE__) . "/../includes/util.php");
require_once(dirname(__FILE__) . "/user/user_core.php");
require_once(dirname(__FILE__) . "/login/login_core.php");
require_once(dirname(__FILE__) . "/employee/employee_core.php");

// --------------------------------------------------------- //
// ----------- General RESTfull API Engine ----------------- //
// --------------------------------------------------------- //
abstract class API
{

    public static $VERSION_NUMBER = 3.0;
    private $_request = array();
    private $_time_start = 0;

    // ------------------------------------------------------- //
    // ----------------- Constructor ------------------------- //
    // ------------------------------------------------------- //
    public function __construct()
    {
 
        $this->_time_start = microtime(true);

        set_exception_handler('API::exceptionHandler');
        set_error_handler('API::errHandle');
        self::cors();

        
        switch ($_SERVER['REQUEST_METHOD']) {
            case "POST":
                $postBody = file_get_contents('php://input');
                if (!json_decode($postBody)) {
                    parse_str($postBody, $postBody);
                    $postBody = json_encode($postBody, JSON_UNESCAPED_UNICODE);
                }
                $this->_request = json_decode($postBody);
                break;
            case "GET":
               
                $this->_request = $this->cleanInputs($_GET);
                break;
        }

        //throw exception in case the user does not provide method name
        if (!array_key_exists("method", $this->_request)) {
            throw new Exception("Method is not provided", 0);
        }

        $param = json_decode(json_encode($this->_request));
    

        try {
            $headers = $this->getRequestHeaders();
           

            if ($headers['refresh-token'] != null) {
                $param->refresh_token = $headers['refresh-token'];
            }
            if ($headers['integration_token'] != null && $headers['integration_token'] != "") {
                $param->integration_token = $headers['integration_token'];
            }
            if ($headers['v'] != null) {
                if ($headers['v'] != self::$VERSION_NUMBER) {
                    throw new Exception("API_VERSION_MISMATCH");
                }
            }
        } catch (Exception $e) {
        }

       
        // in case the session has finished, check the token if exists in the request in order to create new session
        session_start();

        // //in case the user provide idtoken then skip this part
        // if($param->refresh_token && $param->idtoken == $param->refresh_token){
        //     unset($param->refresh_token);
        //     return $param;
        // }
  
        //init cores
        $userCore = new UserCore();
        $loginCore = new LoginCore();
        $employeeCore = new EmployeeCore();
        $company_employee = new CompanyEmployeeCore();
        //in case the user provided "refresh_token" , then try search user info using refresh_token
 
        if (!$_SESSION['user_id'] && $param->refresh_token) {
            $token =  $param->refresh_token;
            $searchFilter = [['key' => 'notification_token', 'val' => $token]];
            $userInfo = $userCore->searchUser($searchFilter, 1, 0, 0);

            if ($userInfo->found_rows > 0) {

                // init session record
                $initSession = new stdClass();
                $initSession->phone_number = $userInfo->data[0]->phone_number;
                $initSession->email = $userInfo->data[0]->email;
                $initSession->token = $token;
                $initSession->user_id = $userInfo->data[0]->id;
                $initSession->account_id = $userInfo->data[0]->account_id;
                $session_id = $this->initPersonalSession($initSession);

                // get user profile
                $userProfile = $userCore->getUserProfile($session_id, $userInfo->data[0]->id);
                $userProfile['session_id'] = $session_id;

                // fill session info using the userProfile
                $this->fillUserSession($userProfile);
            }
        }

        // in case no session is defined and the user provided "idToken"
        if (!$_SESSION['user_id'] && $param->idtoken) {


            //login user by asking google to login using idToken
            $imei = $param->imei;
            $brand = $param->brand;
            $sim_id = "0";
            $idToken = $param->idtoken;

            $userInfo = $loginCore->loginUser($imei, $sim_id, $brand, $idToken);

            // init session record in database
            $initSession = new stdClass();
            $initSession->phone_number = $userInfo['phone_number'];
            $initSession->email = $userInfo['email'];
            $initSession->token = $idToken;
            $initSession->user_id = $userInfo['user_id'];
            $session_id = $this->initPersonalSession($initSession);

            // get user profile
            $userProfile = $userCore->getUserProfile($session_id, $userInfo['user_id']);
            $userProfile['session_id'] = $session_id;

            // fill session info using the userInfo
            $this->fillUserSession($userProfile);
        }
 
        // in case no session is defined yet and the user provided "integration_token"
        if (!$_SESSION['user_id'] &&  $param->integration_token) {
            $token = trim($param->integration_token);
            $searchFilter = [['key' => 'integration_token', 'val' => $token]];

            $userInfo = $userCore->searchUser($searchFilter, 1, 0, 0);

            if ($userInfo->found_rows > 0) {

                // init session record
                $initSession = new stdClass();
                $initSession->phone_number = $userInfo->data[0]->phone_number;
                $initSession->email = $userInfo->data[0]->email;
                $initSession->token = $token;
                $initSession->user_id = $userInfo->data[0]->id;
                $session_id = $this->initPersonalSession($initSession);

                // get user profile
                $userProfile = $userCore->getUserProfile($session_id, $userInfo->data[0]->id);
                $userProfile['session_id'] = $session_id;
                $userProfile['company_id'] = $userInfo->data[0]->company_id;

                // fill session info using the userProfile
                $this->fillUserSession($userProfile);
            }
        }

        // in case no session is defined yet and the user provided "integration_token"
        if (!$_SESSION['company_id'] &&  $param->integration_token) {
            $searchFilter = [['key' => 'integration_token', 'val' => $param->integration_token]];
            $userInfo = $userCore->searchUser($searchFilter, 1, 0, 0);
            $_SESSION['company_id'] = $userInfo->data[0]->company_id;
        }

        if (!$_SESSION['user_id'] &&  $param->device_token) {
            $token = trim($param->device_token);
            $searchFilter = [['key' => 'integration_token', 'val' => $token]];
            $userInfo = $userCore->searchUser($searchFilter, 1, 0, 0);
            if ($userInfo->found_rows > 0) {

                // init session record
                $initSession = new stdClass();
                $initSession->phone_number = $userInfo->data[0]->phone_number;
                $initSession->email = $userInfo->data[0]->email;
                $initSession->token = $token;
                $initSession->user_id = $userInfo->data[0]->id;
                $session_id = $this->initPersonalSession($initSession);

                // get user profile
                $userProfile = $userCore->getUserProfile($session_id, $userInfo->data[0]->id);
                $userProfile['session_id'] = $session_id;

                // fill session info using the userProfile
                $this->fillUserSession($userProfile);

                // switch profile
                $company_id = $userProfile['company_id'] = $userInfo->data[0]->company_id;
                $profile = $company_employee->searchCompanyEmployeeProfile($company_id, $userInfo->data[0]->id, $_SESSION['user_id']);

                $initSessionObj = new stdClass();
                $initSessionObj->details = new stdClass();
                $initSessionObj->details->type = "corporate";
                $initSessionObj->details->ca_id = $profile['ca_info']->id;
                $initSessionObj->details->company_id = $userProfile['company_id'];
                $initSessionObj->details->pa_id = $profile['pa_info']->id;
                $initSessionObj->details->sa_id = $profile['sa_info']->id;
                $initSessionObj->details->co_id = $profile['co_info']->id;
                $initSessionObj->details->company_name = $profile['tc_info']->name;
                $initSessionObj->details->truck_owner_id = $profile['truck_owner_info']->id;
                $initSessionObj->details->company_employee_id = $profile['company_employee_info']->id;
                $initSessionObj->details->trucking_company_id = $profile['tc_info']->id;
                $initSessionObj->details->id = $profile['user_info']->id;
                $initSessionObj->token = $token;

                $session_id = $this->initCorporateSession($initSessionObj);
                $profile['session_id'] = $session_id;

                // fill session object
                $this->fillCompanySession($profile);
            }
        }

        // if none of the above methods was able to create a session , then throw exception
        if (!$_SESSION['user_id']) {
            //throw new Exception("INVALID_TOKEN");
        }
 
        // if there is employee id in session and there is no tenders available for user
        if ($_SESSION['employee_id'] && !$_SESSION['tender_ids']) {
            $employee = $employeeCore->getEmployeeBasic($_SESSION['employee_id'], 0);
            $_SESSION['tender_ids'] = $employee->tender_ids;
        }

        if (array_key_exists("selected_profile", $this->_request)) {
            if (strcasecmp($this->_request['selected_profile'],$_SESSION['type'])!= 0)
            throw new Exception("يرجى تحديث النظام", 500);
        }

        return $param;
    }



    // ----------------
    public function recreate_integration_session($param)
    {
        $userCore = new UserCore();

        $token = $param->integration_token;
        $searchFilter = [['key' => 'integration_token', 'val' => $token]];
        $userInfo = $userCore->searchUser($searchFilter, 1, 0, 0);
        if ($userInfo->found_rows > 0) {

            // init session record
            $initSession = new stdClass();
            $initSession->phone_number = $userInfo->data[0]->phone_number;
            $initSession->email = $userInfo->data[0]->email;
            $initSession->token = $token;
            $initSession->user_id = $userInfo->data[0]->id;
            $session_id = $this->initPersonalSession($initSession);

            // get user profile
            $userProfile = $userCore->getUserProfile($session_id, $userInfo->data[0]->id);
            $userProfile['session_id'] = $session_id;
            $userProfile['company_id'] = $userInfo->data[0]->company_id;

            // fill session info using the userProfile
            $this->fillUserSession($userProfile);
        }
    }

    // ------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------- fill eligible tender ids in employee session ------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------ //
    public function fillSessionWithTenders()
    {
        try {
            $userCore = new UserCore();
            $employeeCore = new EmployeeCore();

            $u_id = $_SESSION['u_id'];
            $userInfo = $userCore->getUserBasic($u_id, $_SESSION['user_id']);
            $employee_id = $userInfo->employee_id;
            $employee = $employeeCore->getEmployeeBasic($employee_id, $_SESSION['user_id']);
            $_SESSION['tender_ids'] = $employee->tender_ids;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------- init user session by creating session record in databas in order to give access for user on the database ------------- //
    // ------------- this change because of the new security technique used in ownership -------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------ //
    public function updatePersonalSession()
    {

        // update session record
        $sessionDetails = [
            "type" => "individual",
            "id" => $_SESSION['u_id'],
            "driver_id" => $_SESSION['driver_id'],
            "truck_owner_id" => $_SESSION['truck_owner_id']
        ];
        $sessionDetails = json_encode($sessionDetails, JSON_UNESCAPED_UNICODE);
        $sqlQuery = "update session set details = ? where id = ?";
        $param = [$sessionDetails, $_SESSION['user_id']];
        try {
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        } catch (Exception $e) {
            // $e->getMessage();
        }
    }


    // ------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------- init user session by creating session record in databas in order to give access for user on the database ------------- //
    // ------------- this change because of the new security technique used in ownership -------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------ //
    public function initPersonalSession($initSessionObj)
    {

        $sid  = round(microtime(true) * 1000) . str_pad(rand(1, 999), 3, "0", STR_PAD_LEFT);
        $sessionDetails = [
            "type" => "individual",
            "id" => $initSessionObj->user_id
        ];

        // log session into database
        $sqlQuery = "insert into session (id,details,google_token, php_session, ip_address,start_session,browser,phone_number,email,update_by)
                     values              (? ,?      ,?           ,?           ,?          ,?            ,?      ,?           ,?    ,?)";
        $param = [
            $sid,
            json_encode($sessionDetails, JSON_UNESCAPED_UNICODE),
            $initSessionObj->token,
            session_id(),
            $this->getIpAddressInfo()->ip,
            DBConnection::getSystemDate(),
            $_SERVER['HTTP_USER_AGENT'],
            $initSessionObj->phone,
            $initSessionObj->email,
            $initSessionObj->user_id ? $initSessionObj->user_id : $_SESSION['user_id']
        ];
        try {
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        } catch (Exception $e) {
        }

        return $sid;
    }



    // ------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------- init corporate session by creating session record in databas in order to give access for user on the database ------------- //
    // ------------- this change because of the new security technique used in ownership -------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------ //
    public function initCorporateSession($initSessionObj)
    {

        $sid  = round(microtime(true) * 1000) . str_pad(rand(1, 999), 3, "0", STR_PAD_LEFT);
        $sessionDetails = $initSessionObj->details;

        // log session into database

        $sqlQuery = "insert into session (id,details,google_token, php_session, ip_address,start_session,browser,phone_number,email,update_by)
                     values              (? ,?      ,?           ,?           ,?          ,?            ,?      ,?           ,?    ,?)";
        $param = [
            $sid,
            json_encode($sessionDetails, JSON_UNESCAPED_UNICODE),
            $initSessionObj->token,
            session_id(),
            $this->getIpAddressInfo()->ip,
            DBConnection::getSystemDate(),
            $_SERVER['HTTP_USER_AGENT'],
            $initSessionObj->phone,
            $initSessionObj->email,
            $initSessionObj->user_id ? $initSessionObj->user_id : $_SESSION['u_id']
        ];
        try {
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        } catch (Exception $e) {
        }

        return $sid;
    }

    // -------------------------------------------------------------- //
    // ------------- get Session record on database ----------------- //
    // -------------------------------------------------------------- //
    public static function getSession($session_id)
    {
        $sqlQuery = "SELECT
                        s.id,
                        CAST(`details` AS CHAR CHARSET UTF8) AS details,
                        s.google_token,
                        s.php_session,
                        s.start_session,
                        s.end_session,
                        s.ip_address,
                        s.browser,
                        CAST(`ip_info` AS CHAR CHARSET UTF8) AS ip_info,
                        s.phone_number,
                        s.email
                    FROM
                        session s
                      WHERE id = ?";
        $param = [$session_id];

        $sessionObj = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        return $sessionObj[0];
    }

    // ---------------------------------------------------------- //
    // ------------- validate corporate Session ----------------- //
    // ---------------------------------------------------------- //
    public function validateCorporateSession()
    {

        // get company employee roles and session database record
        $company_employee_roles = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
        $sessionObj = $this->getSession($_SESSION["user_id"]);

        if (!$sessionObj) {
            throw new Exception("Invalid Session id");
        }
        $sessionDetails = json_decode($sessionObj->details);
        if (!$sessionDetails) {
            throw new Exception("Invalid Session details");
        }

        foreach ($company_employee_roles as $role) {
            $first_letters_of_role = substr($role, 0, 2);
            switch ($first_letters_of_role) {
                case 'TC':
                    if (!$sessionDetails->trucking_company_id || $sessionDetails->trucking_company_id == "") {
                        throw new Exception("Invalid Session, no trucking_company_id is defined");
                    }
                    //if(!$sessionDetails->truck_owner_id||$sessionDetails->truck_owner_id == ""){throw new Exception("Invalid Session, no truck_owner_id is defined");}
                    break;
                case 'CA':
                    if (!$sessionDetails->ca_id || $sessionDetails->ca_id == "") {
                        throw new Exception("Invalid Session, no ca_id is defined");
                    }
                    break;
                case 'PA':
                    if (!$sessionDetails->pa_id || $sessionDetails->pa_id == "") {
                        throw new Exception("Invalid Session, no pa_id is defined");
                    }
                    break;
                case 'SA':
                    if (!$sessionDetails->sa_id || $sessionDetails->sa_id == "") {
                        throw new Exception("Invalid Session, no sa_id is defined");
                    }
                    break;
                case 'CO':
                    if (!$sessionDetails->co_id || $sessionDetails->co_id == "") {
                        throw new Exception("Invalid Session, no co_id is defined");
                    }
                    break;
                default:
                    if (in_array($role, ["COMPANY_OPERATION"])) {
                        break;
                    } else {
                        throw new Exception("Invalid Company Employee Session, 1 role has wrong initial name");
                        break;
                    }
            }
        }
    }


    // ---------------------------------------------------------- //
    // ------------- fill user session info --------------------- //
    // ---------------------------------------------------------- //
    public function fillUserSession($userProfile)
    {

        $_SESSION = [];

        // fill from user bean
        if ($userProfile['USER_BEAN']) {
            $userBean = json_decode($userProfile['USER_BEAN']);
            $_SESSION['type'] = "INDIVIDUAL";
            $_SESSION['user_id'] = $userProfile['session_id'];
            $_SESSION['u_id'] = $userBean->id;
            $_SESSION['user_name'] = $userBean->name;
            $_SESSION['USER_ROLES'] = $userBean->role_code;
            $_SESSION['employee_id'] = $userBean->employee_id;
        } else {
            //throw new Exception("INVALID USER PROFILE");
        }

        if ($userProfile['company_id']) {
            $_SESSION['company_id'] = $userProfile['company_id'];
        }

        if ($userProfile['DRIVER_BEAN']) {
            $driverBean = json_decode($userProfile['DRIVER_BEAN']);
            $_SESSION['driver_id'] = $driverBean->id;
        }

        if ($userProfile['OWNER_BEAN']) {
            $ownerBean = json_decode($userProfile['OWNER_BEAN']);
            $_SESSION['truck_owner_id'] = $ownerBean->id;
        }
        // update session in database
        $this->updatePersonalSession();
    }

    // ---------------------------------------------------------- //
    // ------------- fill company session info --------------------- //
    // ---------------------------------------------------------- //
    public function fillCompanySession($companyProfile)
    {

        // clear old session object
        $_SESSION = [];

        $_SESSION['user_id'] = $companyProfile['session_id'];

        // fill from user bean
        if ($companyProfile['company_employee_info']) {
            $_SESSION['type'] = "CORPORATE";
            $_SESSION['company_employee_id'] = $companyProfile['company_employee_info']->id;
            $_SESSION['company_id'] = $companyProfile['company_employee_info']->company_id;
            $_SESSION['company_name'] = $companyProfile['company_employee_info']->company_name;
            $_SESSION['trucking_company_id'] = $companyProfile['tc_info']->id;
            $_SESSION['COMPANY_EMPLOYEE_ROLES'] = $companyProfile['company_employee_role'];
            $_SESSION['u_id'] = $companyProfile['user_info']->id;
        } else {
            throw new Exception("INVALID COMPANY PROFILE");
        }

        if ($companyProfile['truck_owner_info']) {
            $_SESSION['truck_owner_id'] = $companyProfile['truck_owner_info']->id;
        }
        if ($companyProfile['ca_info']) {
            $_SESSION['ca_id'] = $companyProfile['ca_info']->id;
        }
        if ($companyProfile['pa_info']) {
            $_SESSION['pa_id'] = $companyProfile['pa_info']->id;
        }
        if ($companyProfile['sa_info']) {
            $_SESSION['sa_id'] = $companyProfile['sa_info']->id;
        }

        return $_SESSION;
    }

    public function getRequestHeaders()
    {
        $headers = array();
        if ($_SERVER) {
            foreach ($_SERVER as $key => $value) {
                $header = str_replace(' ', '-', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))));
                $headers[strtolower($header)] = $value;
            }
        }

        return $headers;
    }

    private function getIpAddressInfo()
    {
        //step1
        $cSession = curl_init();
        //step2
        curl_setopt($cSession, CURLOPT_URL, "https://ipinfo.io/" . $_SERVER['REMOTE_ADDR'] . "/json");
        curl_setopt($cSession, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cSession, CURLOPT_HEADER, false);
        //step3
        $result = curl_exec($cSession);
        //step4
        curl_close($cSession);
        //step5
        $result = json_decode($result);
        return $result;
    }

    // ------------------------------------------------------------------------- //
    // -------------clean the params sent to API and store it in struct--------- //
    // ------------------------------------------------------------------------- //
    private function cleanInputs($data)
    {
        $clean_input = array();
        if (is_array($data)) {
            foreach ($data as $k => $v) {
                $clean_input[trim(strtolower($k))] = $this->cleanInputs(trim($v));
            }
        } else {
            if (get_magic_quotes_gpc()) {
                $data = trim(stripslashes($data));
            }
            $data = strip_tags($data);
            $clean_input = trim($data);
        }
        return $clean_input;
    }

    // ----------------------------------------------------------- //
    // -------------generate reposnse with error code 200--------- //
    // ----------------------------------------------------------- //
    public function response($data)
    {
        header("HTTP/1.1 200 OK");
        header("Content-Type: application/json");

        if (getenv('debug_mode') == 1) { // for timing and debuging purposes, turn this on from app.yaml
            $time_end = microtime(true);
            $time = round(($time_end - $this->_time_start) * 1000);
            $Result['result'] = $data;
            $Result['totalDurationProcessing'] = $time;
            $data = $Result;
        }
        echo (json_encode($data, JSON_UNESCAPED_UNICODE));
    }

    // ----------------------------------------------------- //
    // -------------Error Handler like any --------------------- //
    // ----------------------------------------------------- //
    public static function errHandle($level, $text, $file, $line)
    {
        if (!in_array($level, [8, 512, 1024])) { // exclude system and user notice
            throw new Exception($text, 0);
        }
    }

    // ----------------------------------------------------- //
    // -------------Exception Handler ---------------------- //
    // ----------------------------------------------------- //
    public static function exceptionHandler($exception)
    {

        $errorMessage = '';

        // convert DB error messages
        if (strpos($exception->getMessage(), '100 Phone Duplicate!') !== false) {
            $errorMessage = 'رقم الهاتف مستخدم مسبقا';
        }
        if (strpos($exception->getMessage(), 'nn_nat_idx') !== false) {
            $errorMessage = 'الرقم الوطني مستخدم مسبقا';
        }
        if (strpos($exception->getMessage(), '100 No Authority!') !== false) {
            $errorMessage = 'لا يوجد لديك صلاحية ﻹتمام هذه العملية';
        }
        if (strpos($exception->getMessage(), ' 100 رقم الهاتف غير صحيح') !== false) {
            $errorMessage = 'رقم الهاتف غير صحيح';
        }

        if (strpos($exception->getMessage(), "uk_waybill_active_truck")) {
            $errorMessage =  "لا تستطيع المتابعة ، الشاحنة لديها رحلة غير منتهية";
        } else if (strpos($exception->getMessage(), "uk_waybill_active_trailer")) {
            $errorMessage = "لا تستطيع المتابعة ، المقطورة لديها رحلة غير منتهية";
        } else if (strpos($exception->getMessage(), "uk_waybill_active_driver")) {
            $errorMessage = "لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية";
        } else if (strpos($exception->getMessage(), "لا يوجد رصيد كافي بالحساب")) {
            $errorMessage = "لا يوجد رصيد كافي بالحساب";
        }

        if ($errorMessage == '') {
            $errorMessage = $exception->getMessage();
        }


        header("HTTP/1.1 500 Internal Server Error");
        $Result['ERRORCODE'] = $exception->getCode() ? $exception->getCode() : 500;
        $Result['CODE'] = $errorMessage;
        $Result['MESSAGE'] = $errorMessage;
        $Result['TRACE'] = $exception->getTrace();

        $isDebugMode = 0;
        if ($isDebugMode) {
            echo (json_encode($Result, JSON_UNESCAPED_UNICODE));
        } else {
            header("Content-Type: application/json");
            echo (json_encode($Result, JSON_UNESCAPED_UNICODE));
        }
    }

    public static function cors()
    {

        // Allow from any origin
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            $http_origin = $_SERVER['HTTP_ORIGIN'];
            header("Access-Control-Allow-Origin: $http_origin");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day
        } else {
            header("Access-Control-Allow-Origin: *");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day
        }

        // enable SameSite cookie
        if (isset($_COOKIE["PHPSESSID"])) {
            // header('Set-Cookie: PHPSESSID=' . $_COOKIE["PHPSESSID"] . '; SameSite=None; Secure');
            header('Set-Cookie: PHPSESSID=' . $_COOKIE["PHPSESSID"] . '; SameSite=None; Secure');
        }


        // Access-Control headers are received during OPTIONS requests
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
                // may also be using PUT, PATCH, HEAD etc
                header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

            exit(0);
        }

        //echo "You have CORS!";
    }
}
