<?php require_once ('../includes/debug.php');
include_once('simple_html_dom.php');
require_once ('../includes/DBConnection.php');
header('Content-type: text/html');


for ($index = 1 ; $index <= 100 ; $index++){

    try{

        $companyId= rand(1, 250000);
        echo ($companyId . "-");

        // Create DOM from URL or file
        $html = file_get_html("http://www.ccd.gov.jo:7779/ccd/aims_q1a?c_id=". $companyId);
        //$html = file_get_html("comp3.xml");

        // get the main sections of the dom
        $pagetables = $html->find('table');
        
        $isActiveCompany = true;
        $companyInfoTable = null;
        $companyAimTable = null;
        $companyShareHolderTable = null;

        // determine each table block refers to what
        for ($tableIndex = 1 ; $tableIndex < 6 ; $tableIndex++){
            try{
                
                $title = trim(iconv('WINDOWS-1256', 'UTF-8', $pagetables[$tableIndex]->find('font')[0]));
                $title = strip_tags($title);
                $title = str_replace('&nbsp;','',$title);
                $title = str_replace('ـ','',$title);
                $title = trim($title);
                
                //echo $title . "</br>";

                if ( $title == "معلومات عن الشركة" ){
                    $companyInfoTable = $pagetables[$tableIndex];
                }
                else if ( $title == "غايات الشركة"){
                    $companyAimTable = $pagetables[$tableIndex];
                }
                else if ($title == "الشركاء" ){
                    $companyShareHolderTable = $pagetables[$tableIndex];
                }
            }
            catch(Exception $e){
                // skip
            }
        }

        //echo ($companyShareHolderTable);die;


        // Find all basic info for the company 
        foreach($companyInfoTable->find('font') as $element) {
            
            $info = explode(":", $element);
        
            if(sizeof($info) > 1){
                $key = strip_tags($info[0]);
                
                $key = str_replace('&nbsp;','',$key);
                $key = trim($key);
                $key = iconv('WINDOWS-1256', 'UTF-8', $key);
                 
                if ($key == 'صفة الشركة'){
                    $key = "sefat";
                }
                else if ($key == 'نوع الشركة'){
                    $key = "type";
                }else if ($key == 'الرقم الوطني للمنشأه'){
                    $key = "nn";
                }else if ($key == 'اسم الشركة'){
                    $key = "name";
                }
                else if ($key == 'رقم الشركة'){
                    $key = "company_number";
                }
                else if ($key == 'حالة الشركة'){
                    $key = "company_status";
                }
                else if ($key == 'تاريخ تسجيل الشركة'){
                    $key = "registration_date";
                }
                else if ($key == 'صندوق البريد'){
                    $key = "po_box";
                }
                else if ($key == 'الرمز البريدي'){
                    $key = "postal_code";
                }
                else if ($key == 'رأس المال عند التسجيل'){
                    $key = "initial_capital";
                }
                else if ($key == 'رأس المال الحالي'){
                    $key = "current_capital";
                }
                else if ($key == 'المدينة'){
                    $key = "city";
                }
                else if ($key == 'هاتف اول'){
                    $key = "phone";
                }
                else if ($key == 'الفاكس'){
                    $key = "fax";
                }
                else if ($key == 'البريد الالكتروني'){
                    $key = "email";
                }
                else{
                    $key = "";
                }

                $value = strip_tags($info[1]);
                $value = str_replace('&nbsp;','',$value);
                $value = trim($value);
                $value = iconv('WINDOWS-1256', 'UTF-8', $value);
                if($key == "registration_date" && $value && $value != ""){ 
                    $value = DateTime::createFromFormat('d/m/Y', $value)->format('Y-m-d');
                }
                if($key == "current_capital" || $key == "initial_capital"){ 
                    $value = str_replace(",","",$value);
                }

                if($key != '')
                    $result["$key"] = $value;
            }
        } 

        // get company aims and shares as JSON in case the company is active
        if($companyAimTable){
            $companyAims = getCompanyAims($companyAimTable);
            $result["aims"] = $companyAims;

        }else{
            $result["aims"] = "[{}]";
        }
        if($companyShareHolderTable){
            $shareHolders = getShareHolders($companyShareHolderTable);    
            $result["share_holders"] = $shareHolders;

        }else{
            $result["share_holders"] = "[{}]";
        }

        $result['id'] = $companyId;

        DBConnection::getInstance();

        // search for id, if exist then update record else create new one
        $companyFilter = [['key'=>'id','val' => $companyId ,'op' => '=']];
        $companyExist = DBConnection::searchDB("company",$companyFilter,1,0,0);
 
        if($companyExist->found_rows > 0){
            $createTruckContractResult = DBConnection::updateDB("company",(object)$result,0);
        }else{
            $createTruckContractResult = DBConnection::insertDB("company",(object)$result,0);
        }

    }
    catch(Exception $e){
        var_dump($e);
    }

}




function getCompanyAims($aimsDom){
    $aims = [];
    foreach($aimsDom->find('font') as $element) {
        $value = iconv('WINDOWS-1256', 'UTF-8', $element->plaintext);
        array_push($aims,$value);
    }
    $aims2 = [];
     
    for ($x = 1; $x <= sizeOf($aims); $x += 2) {
        if($x < sizeOf($aims) && $aims[$x]) {
            $tempAim = new stdClass();
            $tempAim->id = trim(str_replace('&nbsp;','',$aims[$x]));
            $tempAim->value = trim(str_replace('&nbsp;','',$aims[$x+1]));
        
            array_push($aims2,$tempAim);
        }
    } 
    return (json_decode(json_encode($aims2,JSON_UNESCAPED_UNICODE)));
}

function getShareHolders($dom){
    $shares = [];
    foreach($dom->find('font') as $element) {
        $value = iconv('WINDOWS-1256', 'UTF-8', $element->plaintext);
        $value = addslashes($value);
        array_push($shares,$value);
    }

    $shares2 = [];
    
    for ($x = 6; $x <= sizeOf($shares); $x += 5) {
        try{
            if($x < sizeOf($shares)) {
                $tempAim = new stdClass();
               
                $tempAim->name = trim(str_replace('&nbsp;','',$shares[$x]));
                $tempAim->type = trim(str_replace('&nbsp;','',$shares[$x+1]));
                $tempAim->nat = trim(str_replace('&nbsp;','',$shares[$x+2]));
                $tempAim->share = trim(str_replace('&nbsp;','',$shares[$x+3]));
                $tempAim->nn = trim(str_replace('&nbsp;','',$shares[$x+4]));
                
                array_push($shares2,$tempAim);
            }
        }
        catch(Exception $e){
           // skip
        }
    } 
     
    return (json_decode(json_encode($shares2,JSON_UNESCAPED_UNICODE)));
}
