<?php
ini_set('max_execution_time', 600); //600 seconds = 10 minutes

require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");

error_reporting(E_ERROR | E_PARSE);

$waybillCore = new WaybillCore();
$queueCore = new QueueCore();

$startRow = $_GET['startRow'];
$limit = $_GET['limit'];
$filePath = 'old_waybills.csv';
$created_by = 2;
$tender_id = 3;
$q_id = 1;
$erros = [];

$result = parseCsvFile($filePath,$startRow,$limit);
$onQueue = 0;

foreach ($result as $truck) {

    try{
        // ----------------------------- Prepare Data -----------------------------------
        $wn = $truck[0];
        $tn = $truck[1];

        $waybillFilter = [['key'=>'wn','val' =>$wn]];
        $waybillResult = $waybillCore->searchWaybills($waybillFilter,1, 0, $created_by );      
 
        $waybill_id = $waybillResult->data[0]->id;
        $truck_ID = $waybillResult->data[0]->truck_id;
        $trailer_id = $waybillResult->data[0]->trailer_id;
        $driver_id = $waybillResult->data[0]->driver_id;

        // ---------------------------- check to see if truck already has active queue --------------
        $queueFilter = [['key'=>'tn','val' =>$tn],['key'=>'status','val' => ['ACTIVE','PENDING'], 'op' => 'in']];
        $queueResult = $queueCore->searchQueue($queueFilter,1, 0, $created_by ); 
        if($queueResult->found_rows > 0){
            dump($queueResult->data);
        }
        


        // ----------------------------- change status of waybill to INACTIVE ----------------
        //$waybillCore->changeStatus($waybill_id, 'INACTIVE',$created_by);

        // ------------------------ Add to Queue ----------------------------------------
        //$addQueueId = $queueCore->addQueue($truck_ID,$driver_id,$trailer_id, $q_id,$tender_id,$created_by);
    }
    catch (Exception $e){
        $errorObj = new stdClass();
        $errorObj->tn = $tn;
        $errorObj->error = 'TRUCK.NOT.REGISTERED';
        array_push($erros, $errorObj);
    }
}