<?php
ini_set('max_execution_time', 24000); //600 seconds = 10 minutes
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/user/user_core.php");
require_once (dirname(__FILE__)."/../core/driver/driver_core.php");
error_reporting(E_ERROR | E_PARSE);
$userCore = new UserCore();
$driverCore = new DriverCore();
$created_by = 2;

$filePath = 'oldDrivers.csv';

$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

$result = parseCsvFile($filePath,$startRow,$limit);
$erros = [];
  
foreach ($result as $driver) {
    
    try{

    
        $user_id = null;
        $driver_id = null;

        // ----------------------------- Prepare Data -----------------------------------
        $driver_name = $driver[0];
        $nat_code = $driver[1];
        $license_number = $driver[2];
        $nn = $driver[3];
        $phone_number = $driver[7];
        $dateArr = explode("/", $driver[6]);    
        $license_expiry_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];

        // --------------------- search for user --------------------------------------------
        $searchFilter = new stdClass();
        $searchFilter = [['key'=>'phone_array','val' =>$phone_number ,'op' => 'like']];       
        $userInfo = $userCore->searchUser($searchFilter,1,0,$created_by);
         
        // -------------------- create User if not exist ------------------------------------
    
        if($userInfo->found_rows > 0 ){
            $user_id = $userInfo->data[0]->id;
        }else{          
            $userBean = new stdClass();
            $userBean->name = $driver_name;
            $userBean->nn = $nn;
            $userBean->nat_code = $nat_code;
            $phone_array = [];
            $phone_info = new stdClass();
            $phone_info->sim = 0;
            $phone_info->phone = convertToInternational($phone_number);
            $phone_info->imei = 0;
            $phone_info->verification_method = 'NONE';
            $phone_array[0]=$phone_info;
            $userBean->phone_array = json_decode(json_encode($phone_array)) ;

            $user_id = $userCore->registerNewUser( $userBean, $created_by );        
        }

        // ----------------------- create Driver if not exist------------------- 
        $searchFilter = new stdClass();
        $searchFilter = [['key'=>'user_id','val' =>$user_id ]];
        $driverInfo = $driverCore->searchDriver($searchFilter,1,0,$created_by);
     
        if($driverInfo->found_rows > 0 ){
            $driver_id = $driverInfo->data[0]->id;
        }else{      
            $driverBean = new stdClass();
            $driverBean->user_id = $user_id;
            $driverBean->license_number = $license_number;        
            $driverBean->license_expiry_date = $license_expiry_date;
        
            $driverResult = $driverCore->createDriver($driverBean,$user_id,$created_by);             
            $driver_id = $driverResult[0]['@id'];          
        }


        // ----------------------- Output result --------------------------------
        echo "User id = $user_id </br>";
        echo "driver id = $driver_id </br>";
        echo "</br>";

    }catch(Exception $e){
        $errorObj = new stdClass();
        $errorObj->driver_name = $driver_name;
        $errorObj->nn = $nn;
        $errorObj->phone_number = $phone_number;
        $errorObj->error = $e->getMessage();
 
        array_push($erros, $errorObj);
    }
 
}