<?php
ini_set('max_execution_time', 600); //600 seconds = 10 minutes

// ----------------------- INIT --------------------------------------
require_once ('../includes/DBConnection.php');
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/user/user_core.php");
require_once (dirname(__FILE__)."/../core/driver/driver_core.php");
require_once (dirname(__FILE__)."/../core/truck_owner/truck_owner_core.php");
require_once (dirname(__FILE__)."/../core/truck/truck_core.php");
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../core/queue/queue_core.php");

error_reporting(E_ERROR | E_PARSE);

$erros = [];
$created_by = 2;
$tender_id = 3;
$q_id = 1;

$userCore = new UserCore();
$driverCore = new DriverCore();
$truckOwnerCore = new TruckOwnerCore();
$truckCore = new TruckCore();
$truckContractCore = new TruckContractCore();
$tenderCore = new TenderCore();
$queueCore = new QueueCore();

$startRow = $_GET['startRow'];
$limit = $_GET['limit'];

// -------------------- read excel sheet -------------------------------
$row = 0;
$processedRows = 0;
$startProcess = false;
if (($handle = fopen("queues.csv", "r")) !== FALSE) {

    // -------------------- loop on excel sheet and extract data -----------
    while (($data = fgetcsv($handle, 10000, ",")) !== FALSE) {

        $row ++;
        if($row < $startRow){
            continue;
        }

        $processedRows++;
        if($processedRows > $limit){ // get limit truck only
            dump($erros);die;
        }

        try{
         
        $phone_number = convertToInternational($data[10]);
        $user_name = $data[8];
        $nn = $data[7];
        $tn = $data[3];
        $trn = $data[4];
        $truck_owner_name = $data[8];
        $nationality_code = 'JOR';
        $trailer_tt = '920200';         // بضائع
        $truck_tt = '920000';           // الكل 
        $truck_minor_tt = 9;            // رأس قاطر
        $trailer_minor_tt = $data[6];
        $truck_cat = 'TRUCK';
        $triler_cat = 'TRAIL-HALF';

    // -------------------- create User if not exist ------------------------------------

        $searchFilter = new stdClass();
        $searchFilter = [['key'=>'phone_array','val' =>$phone_number ,'op' => 'json','node'=>'phone']];
        $userInfo = $userCore->searchUser($searchFilter,1,0,$created_by);
   
        if($userInfo->found_rows > 0 ){
            $user_id = $userInfo->data[0]->id;
        }else{          
            $userBean = new stdClass();
            $userBean->name = $user_name;
            $userBean->nn = $nn;
            $phone_array = [];
            $phone_info = new stdClass();
            $phone_info->sim = 0;
            $phone_info->phone = convertToInternational($phone_number);
            $phone_info->imei = 0;
            $phone_info->verification_method = 'NONE';
            $phone_array[0]=$phone_info;
            $userBean->phone_array = json_decode(json_encode($phone_array)) ;
     
            $userResult = $userCore->registerNewUser( $userBean, $created_by );
            $user_id = $userResult;
        }

    // ---------------------- create truck owner if exist  ------------------------------------

        $searchFilter = new stdClass();
        $truckOwnerFilter = [['key'=>"user_id",'val' => $user_id]];
        $truckOwnerQuery = $truckOwnerCore->searchTruckOwner($truckOwnerFilter, 1, 0, $created_by );
        if($truckOwnerQuery->found_rows > 0 ){
            $truckOwnerID = $truckOwnerQuery->data[0]->id;
        }else{
            $truckOwnerBean = new stdClass();
            $truckOwnerBean->user_id = $user_id;    
            $truckOwnerID = $truckOwnerCore->createTruckOwner($truckOwnerBean, $created_by);
        }


    // ----------------------- create Truck if not exist--------------------------------------------

        $truckFilter = [['key'=>'tn','val' =>$tn],
                        ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in']
                       ];
        $truckResult = $truckCore->searchTrucks($truckFilter,1, 0, $created_by );

        if($truckResult->found_rows > 0){
            $truck_ID=$truckResult->data[0]->id;
        }else{
            $truckBean = new stdClass();
            $truckBean->tn = $tn;
            $truckBean->nationality_code = $nationality_code;
            $truckBean->tt = $truck_tt;
            $truckBean->minor_tt = $truck_minor_tt;
            $truckBean->cat = $truck_cat;
            $truckBean->truck_owner_name = $truck_owner_name;
            $truck_ID=$truckCore->createTruck($truckBean,$truckOwnerID,$created_by);
        }       

    // ----------------------- create truck contract if not exist------------------------------------
    
        $contractFilter = [['key'=>'tn','val' =>$tn],
                           ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                           ['key'=>'truck_owner_id','val' =>$truckOwnerID],
                           ['key'=>'contract_type','val' =>'OWN']];
        $contract_qry = $truckContractCore->searchTruckContracts($contractFilter,1, 0, $created_by );

        if($contract_qry->found_rows > 0){
            $contract_id = $contract_qry->data[0]->id;
        }else{
            $truckContractBean = new stdClass();
            $truckContractBean->truck_owner_id = $truckOwnerID;
            $truckContractBean->truck_id = $truck_ID;
            $truckContractBean->contract_type = 'OWN';
            $truckContractBean->photos = [];
 
            $contract_id = $truckContractCore->createTruckContract($truckContractBean, $created_by);
        }
       
 
        // update truck status to ACTIVE
        $truckCore->changeStatus($truck_ID,'ACTIVE',$created_by);

    // ----------------------- create Trailer if not exist--------------------------------------------

        $trailerFilter = [['key'=>'tn','val' =>$trn],
                          ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in']
                         ];
        $trailerResult = $truckCore->searchTrucks($trailerFilter,1, 0, $created_by );
 

        if($trailerResult->found_rows > 0){
            $trailer_id=$truckResult->data[0]->id;
        }else{
            $trailerBean = new stdClass();
            $trailerBean->tn = $trn;
            $trailerBean->nationality_code = $nationality_code;
            $trailerBean->tt = $trailer_tt;
            $trailerBean->minor_tt = $trailer_minor_tt;
            $trailerBean->cat = $trailer_cat;
            $trailerBean->truck_owner_name = $truck_owner_name;
            $trailer_id=$truckCore->createTruck($trailerBean,$truckOwnerID,$created_by);           

        }       

    // ----------------------- create trailer contact if not exist------------------------------------

        $contractFilter = [['key'=>'truck_id','val' =>$trailer_id],
                           ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                           ['key'=>'truck_owner_id','val' =>$truckOwnerID],
                           ['key'=>'contract_type','val' =>'OWN']];
        $trailerContract_qry = $truckContractCore->searchTruckContracts($contractFilter,1, 0, $created_by );
  
        if($trailerContract_qry->found_rows > 0){
            $trailer_contract_id = $trailerContract_qry->data[0]->id;
        }else{
            $trailerContractBean = new stdClass();
            $trailerContractBean->truck_owner_id = $truckOwnerID;
            $trailerContractBean->truck_id = $trailer_id;
            $trailerContractBean->contract_type = 'OWN';
            $trailerContractBean->photos = [];

            $trailer_contract_id = $truckContractCore->createTruckContract($trailerContractBean, $created_by);            
        }

        // update trailer status to ACTIVE
        $truckCore->changeStatus($trailer_id,'ACTIVE',$created_by);

    // ----------------------- Add to tender Truck ------------------------------------------

        $tenderTruckSearch = [['key'=>'tender_id','val' => $tender_id ,'op' => '='],
                         ['key'=>'truck_id','val' => $truck_ID],
                         ['key'=>'status','val' => 'ACTIVE' ,'op' => '=']];
        $tenderTruckResult = $tenderCore->searchTenderTruck($tenderTruckSearch, 1,0,$created_by);

        if($tenderTruckResult->found_rows){
            $tenderTruckId = $tenderTruckResult->data[0]->id;
        }else{
            $tenderTruck = new stdClass();
            $tenderTruck->truck_id = $truck_ID;
            $tenderTruck->tender_id = $tender_id;
            $tenderTruck->q_id = $q_id;
    
            $question1 = new stdClass();
            $question1->id = 1;
            $question1->val = [91000000]; // الاردن
            $question2->id = 2;
            $question2->val = [91090000]; // العقبة
            $question3->id = 3;
            $question3->val = '_TRUCK_$_MINOR_TT_';
            $tenderTruck->questionnaire = [$question1,$question2,$question3];
            $tenderTruck->photos = [];
            $tenderTruckId = $tenderCore->createTenderTruck($tenderTruck,$created_by);

            // update tender truck status to ACTIVE
            $tenderCore->changeTruckStatus($tenderTruckId, 'ACTIVE', $created_by);
        }
       

        // ----------------------- add to company fleet if not exist---------------

        $contractFilter = [['key'=>'truck_id','val' =>$trailer_id],
                           ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                           ['key'=>'truck_owner_id','val' =>$truckOwnerID],
                           ['key'=>'contract_type','val' =>'JOIN']];
        $companyFleet_qry = $truckContractCore->searchTruckContracts($contractFilter,1, 0, $created_by );
        if($companyFleet_qry->found_rows){
            $createTruckContractResult = $companyFleet_qry->data[0]->id;
        }else{

            $truckContractBean = new stdClass();
            $truckContractBean->truck_owner_id = $truckOwnerID;
            $truckContractBean->truck_id = $truck_ID;
            $truckContractBean->contract_type = 'JOIN';
            $truckContractBean->photos = [];

            $createTruckContractResult = $truckContractCore->createTruckContract($truckContractBean, $created_by );
        }

        // ------------------------ add to queue ----------------------
        //$addQueueId = $queueCore->addQueue($truck_ID,null,$trailer_id, $q_id,$tender_id,$created_by);

 
    }catch(Exception $e){

       $errorObj = new stdClass();
       $errorObj->tn = $tn;
       $errorObj->phone_number = $phone_number;
       $errorObj->user_name = $user_name;
       $errorObj->error = $e->getMessage();

       array_push($erros, $errorObj);
    }

    }
    fclose($handle);
}


