<?php
error_reporting(E_ERROR | E_PARSE);
require_once ('../includes/util.php');
require_once (dirname(__FILE__)."/../core/truck/truck_core.php");
require_once (dirname(__FILE__)."/../core/truck_contract/truck_contract_core.php");
require_once (dirname(__FILE__)."/../core/tender/tender_core.php");

$erros = [];
$created_by = 2;
$tender_id = 3;
$q_id = 1;
$tender_company_id = 1;
$truckOwnerID = 410018;     // 410018 = Adel Truck Owner Id

$truckCore = new TruckCore();
$truckContractCore = new TruckContractCore();
$tenderCore = new TenderCore();

$startRow = $_GET['startRow'];
$limit = $_GET['limit'];
$filePath = 'tender_trucks.csv';

$result = parseCsvFile($filePath,$startRow,$limit);

foreach ($result as $truck) {

    try{
        // ----------------------------- Prepare Data -----------------------------------
        $tn = $truck[3];
        $trn = $truck[4];

        // ----------------------------- search tender truck Bean ---------------------------------
        $tenderSearchFilter = [['key'=>'tn','val' =>$tn],
                               ['key'=>'q_id','val' =>$queue_id],
                               ['key'=>'tender_id','val' =>$tender_id],
                               ['key'=>'status','val' =>'ACTIVE']];
        $tenderTruckResult = $tenderCore->searchTenderTruck($tenderSearchFilter,1,0,$user_id) ;

        $tender_truck_id = $tenderTruckResult->data[0]->id;
        $truck_ID = $tenderTruckResult->data[0]->truck_ID;

        // ----------------------------- Get trailer Bean ---------------------------------
        $truckFilter = [['key'=>'tn','val' =>$trn],
                        ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in']
                    ];
        $truckResult = $truckCore->searchTrucks($truckFilter,1, 0, $created_by );    
        if($truckResult->found_rows > 0){
            $trailer_id=$truckResult->data[0]->id;
        }

        $tenderTruck = new stdClass();
        $tenderTruck->trailer_id = $trailer_id;
        updateTenderTruck($tenderTruck, $tender_truck_id, $created_by);


        // ------------------------ Add to Queue ----------------------------------------
        $addQueueId = $queueCore->addQueue($truck_ID,null,$trailer_id, $q_id,$tender_id,$created_by);


    }
    catch (Exception $e){
        $errorObj = new stdClass();
        $errorObj->tn = $tn;
        $errorObj->error = 'TRUCK.NOT.REGISTERED';
        array_push($erros, $errorObj);
    }
}

dump($erros);

 


